/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.List;
import org.sonar.api.BatchComponent;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.DryRun;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrapper.EnvironmentInformation;

public final class BatchExtensionInstaller
implements BatchComponent {
    private BatchPluginRepository pluginRepository;
    private EnvironmentInformation environment;
    private DryRun dryRun;

    public BatchExtensionInstaller(BatchPluginRepository pluginRepository, EnvironmentInformation environment, DryRun dryRun) {
        this.pluginRepository = pluginRepository;
        this.environment = environment;
        this.dryRun = dryRun;
    }

    public void install(Module module) {
        for (Plugin plugin : this.pluginRepository.getPlugins()) {
            for (Object extension : plugin.getExtensions()) {
                this.installExtension(module, extension);
            }
        }
        this.installExtensionProviders(module);
        this.installMetrics(module);
    }

    private void installMetrics(Module module) {
        for (Metrics metrics : module.getComponents(Metrics.class)) {
            for (Metric metric : metrics.getMetrics()) {
                module.addComponent(metric.getKey(), metric);
            }
        }
    }

    void installExtensionProviders(Module module) {
        List<ExtensionProvider> providers = module.getComponents(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            Object obj = provider.provide();
            if (obj instanceof Iterable) {
                for (Object extension : (Iterable)obj) {
                    this.installExtension(module, extension);
                }
                continue;
            }
            this.installExtension(module, obj);
        }
    }

    void installExtension(Module module, Object extension) {
        if (ExtensionUtils.isBatchExtension(extension) && ExtensionUtils.isSupportedEnvironment(extension, this.environment) && ExtensionUtils.checkDryRun(extension, this.dryRun.isEnabled()) && ExtensionUtils.isInstantiationStrategy(extension, "PER_BATCH")) {
            if (ExtensionUtils.isType(extension, CoverageExtension.class)) {
                throw new IllegalArgumentException("Instantiation strategy PER_BATCH is not supported on CoverageExtension components: " + extension);
            }
            module.addComponent(extension);
        }
    }
}

