/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.ServerMetadata;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.core.plugin.JpaPluginFile;

public final class ExtensionDownloader {
    private HttpDownloader httpDownloader;
    private TempDirectories workingDirectories;
    private String baseUrl;

    public ExtensionDownloader(HttpDownloader httpDownloader, TempDirectories workingDirectories, ServerMetadata server) {
        this.httpDownloader = httpDownloader;
        this.workingDirectories = workingDirectories;
        this.baseUrl = server.getURL();
    }

    public File downloadJdbcDriver() {
        String url = this.baseUrl + "/deploy/jdbc-driver.jar";
        try {
            File jdbcDriver = new File(this.workingDirectories.getRoot(), "jdbc-driver.jar");
            this.httpDownloader.download(new URI(url), jdbcDriver);
            return jdbcDriver;
        }
        catch (URISyntaxException e) {
            throw new SonarException("Fail to download the JDBC driver from : " + url, (Throwable)e);
        }
    }

    public File downloadExtension(JpaPluginFile extension) {
        File targetFile = new File(this.workingDirectories.getDir(extension.getPluginKey()), extension.getFilename());
        String url = this.baseUrl + "/deploy/plugins/" + extension.getPluginKey() + "/" + extension.getFilename();
        try {
            this.httpDownloader.download(new URI(url), targetFile);
            return targetFile;
        }
        catch (URISyntaxException e) {
            throw new SonarException("Fail to download extension: " + url, (Throwable)e);
        }
    }
}

