/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import java.util.Collections;
import java.util.List;
import org.sonar.api.BatchExtension;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.RuleFailureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.database.model.SnapshotSource;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.index.ResourcePersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PastViolationsLoader
implements BatchExtension {
    private DatabaseSession session;
    private ResourcePersister resourcePersister;

    public PastViolationsLoader(DatabaseSession session, ResourcePersister resourcePersister) {
        this.session = session;
        this.resourcePersister = resourcePersister;
    }

    public List<RuleFailureModel> getPastViolations(Resource resource) {
        if (resource == null) {
            return Collections.emptyList();
        }
        Snapshot snapshot = this.resourcePersister.getSnapshot(resource);
        if (snapshot == null) {
            throw new SonarException("This resource has no snapshot ???" + resource);
        }
        Snapshot previousLastSnapshot = this.resourcePersister.getLastSnapshot(snapshot, true);
        if (previousLastSnapshot == null) {
            return Collections.emptyList();
        }
        return this.session.getResults(RuleFailureModel.class, new Object[]{"snapshotId", previousLastSnapshot.getId()});
    }

    public SnapshotSource getSource(Resource resource) {
        Snapshot snapshot = this.resourcePersister.getSnapshot(resource);
        return (SnapshotSource)this.session.getSingleResult(SnapshotSource.class, new Object[]{"snapshotId", snapshot.getId()});
    }
}

