/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.resources.Resource;
import org.sonar.batch.components.PastSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PastMeasuresLoader
implements BatchExtension {
    private Map<Integer, Metric> metricByIds;
    private DatabaseSession session;

    public PastMeasuresLoader(DatabaseSession session, MetricFinder metricFinder) {
        this(session, metricFinder.findAll());
    }

    PastMeasuresLoader(DatabaseSession session, Collection<Metric> metrics) {
        this.session = session;
        this.metricByIds = Maps.newHashMap();
        for (Metric metric : metrics) {
            if (!metric.isNumericType()) continue;
            this.metricByIds.put(metric.getId(), metric);
        }
    }

    public Collection<Metric> getMetrics() {
        return this.metricByIds.values();
    }

    public List<MeasureModel> getPastMeasures(Resource resource, PastSnapshot projectPastSnapshot) {
        return this.getPastMeasures(resource, projectPastSnapshot.getProjectSnapshot());
    }

    public List<MeasureModel> getPastMeasures(Resource resource, Snapshot projectSnapshot) {
        if (this.isPersisted(resource) && projectSnapshot != null) {
            return this.getPastMeasures(resource.getId(), projectSnapshot);
        }
        return Collections.emptyList();
    }

    public List<MeasureModel> getPastMeasures(int resourceId, Snapshot projectSnapshot) {
        String hql = "select m from " + MeasureModel.class.getSimpleName() + " m, " + Snapshot.class.getSimpleName() + " s " + "where m.snapshotId=s.id and m.metricId in (:metricIds) and m.ruleId=null and m.rulePriority=null and m.characteristic=null " + "and (s.rootId=:rootSnapshotId or s.id=:rootSnapshotId) and s.resourceId=:resourceId and s.status=:status";
        return this.session.createQuery(hql).setParameter("metricIds", this.metricByIds.keySet()).setParameter("rootSnapshotId", ObjectUtils.defaultIfNull((Object)projectSnapshot.getRootId(), (Object)projectSnapshot.getId())).setParameter("resourceId", (Object)resourceId).setParameter("status", (Object)"P").getResultList();
    }

    private boolean isPersisted(Resource resource) {
        return resource.getId() != null;
    }
}

