/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.batch.DecoratorsSelector;
import org.sonar.batch.DefaultDecoratorContext;
import org.sonar.batch.index.DefaultIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorsExecutor
implements BatchComponent {
    private DecoratorsSelector decoratorsSelector;
    private DatabaseSession session;
    private static final Logger LOG = LoggerFactory.getLogger(DecoratorsExecutor.class);
    private DefaultIndex index;

    public DecoratorsExecutor(BatchExtensionDictionnary extensionDictionnary, DefaultIndex index, DatabaseSession session) {
        this.decoratorsSelector = new DecoratorsSelector(extensionDictionnary);
        this.session = session;
        this.index = index;
    }

    public void execute(Project project) {
        LoggerFactory.getLogger(DecoratorsExecutor.class).info("Execute decorators...");
        Collection<Decorator> decorators = this.decoratorsSelector.select(project);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decorators: {}", (Object)StringUtils.join(decorators, (String)" -> "));
        }
        DecoratorsProfiler profiler = new DecoratorsProfiler(decorators);
        this.decorateResource((Resource)project, decorators, true, profiler);
        this.session.commit();
        profiler.log();
    }

    private DecoratorContext decorateResource(Resource resource, Collection<Decorator> decorators, boolean executeDecorators, DecoratorsProfiler profiler) {
        ArrayList childrenContexts = Lists.newArrayList();
        Iterator<Resource> i$ = this.index.getChildren(resource).iterator();
        while (i$.hasNext()) {
            Resource child;
            boolean isModule = (child = i$.next()) instanceof Project;
            DefaultDecoratorContext childContext = (DefaultDecoratorContext)this.decorateResource(child, decorators, !isModule, profiler);
            childrenContexts.add(childContext.setReadOnly(true));
        }
        DefaultDecoratorContext context = new DefaultDecoratorContext(resource, this.index, childrenContexts, this.session);
        if (executeDecorators) {
            for (Decorator decorator : decorators) {
                profiler.start(decorator);
                decorator.decorate(resource, (DecoratorContext)context);
                profiler.stop();
            }
        }
        return context;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DecoratorsProfiler {
        Collection<Decorator> decorators;
        Map<Decorator, Long> durations = new IdentityHashMap<Decorator, Long>();
        long startTime;
        Decorator currentDecorator;

        DecoratorsProfiler(Collection<Decorator> decorators) {
            this.decorators = decorators;
            for (Decorator decorator : decorators) {
                this.durations.put(decorator, 0L);
            }
        }

        void start(Decorator decorator) {
            this.startTime = System.currentTimeMillis();
            this.currentDecorator = decorator;
        }

        void stop() {
            Long cumulatedDuration = this.durations.get(this.currentDecorator);
            this.durations.put(this.currentDecorator, cumulatedDuration + (System.currentTimeMillis() - this.startTime));
        }

        void log() {
            LOG.debug(this.getMessage());
        }

        String getMessage() {
            StringBuilder sb = new StringBuilder("Decorator time:" + SystemUtils.LINE_SEPARATOR);
            for (Decorator decorator : this.decorators) {
                sb.append("\t").append(decorator.toString()).append(": ").append(this.durations.get(decorator)).append("ms").append(SystemUtils.LINE_SEPARATOR);
            }
            return sb.toString();
        }
    }
}

