/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.indexer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bucket<RESOURCE extends Resource> {
    private RESOURCE resource;
    private Snapshot snapshot;
    private ListMultimap<String, Measure> measuresByMetric = ArrayListMultimap.create();
    private boolean sourceSaved = false;
    private Bucket<Project> project;
    private Bucket<?> parent;
    private List<Bucket<?>> children;

    public Bucket(RESOURCE resource) {
        this.resource = resource;
    }

    public RESOURCE getResource() {
        return this.resource;
    }

    public Bucket<Project> getProject() {
        return this.project;
    }

    public Bucket<RESOURCE> setProject(Bucket<Project> project) {
        this.project = project;
        return this;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public Integer getSnapshotId() {
        if (this.snapshot != null) {
            return this.snapshot.getId();
        }
        return null;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public void setParent(Bucket parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    private void addChild(Bucket bucket) {
        if (this.children == null) {
            this.children = Lists.newArrayList();
        }
        this.children.add(bucket);
    }

    private void removeChild(Bucket bucket) {
        if (this.children != null) {
            this.children.remove(bucket);
        }
    }

    public List<Bucket<?>> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public Bucket getParent() {
        return this.parent;
    }

    public void addMeasure(Measure measure) {
        this.measuresByMetric.put((Object)measure.getMetric().getKey(), (Object)measure);
    }

    public boolean isSourceSaved() {
        return this.sourceSaved;
    }

    public void setSourceSaved(boolean b) {
        this.sourceSaved = b;
    }

    public void clear() {
        this.measuresByMetric = null;
        this.children = null;
        if (this.parent != null) {
            super.removeChild(this);
        }
    }

    public boolean isExcluded() {
        return this.resource.isExcluded();
    }

    public boolean isPersisted() {
        return this.resource.getId() != null;
    }

    public Integer getResourceId() {
        return this.resource.getId();
    }

    public <M> M getMeasures(MeasuresFilter<M> filter) {
        Collection unfiltered = filter instanceof MeasuresFilters.MetricFilter ? this.measuresByMetric.get((Object)((MeasuresFilters.MetricFilter)filter).filterOnMetric().getKey()) : this.measuresByMetric.values();
        return (M)filter.filter(unfiltered);
    }
}

