/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.RuleFailureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.Violation;
import org.sonar.jpa.dao.RulesDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationsDao {
    private RulesProfile profile;
    private DatabaseSession session;
    private RulesDao rulesDao;
    private boolean reuseExistingRulesConfig;

    public ViolationsDao(RulesProfile profile, DatabaseSession session, RulesDao rulesDao, Project project) {
        this.profile = profile;
        this.session = session;
        this.rulesDao = rulesDao;
        this.reuseExistingRulesConfig = project.getReuseExistingRulesConfig();
    }

    public List<Violation> getViolations(Resource resource, Integer snapshotId) {
        List models = this.session.getResults(RuleFailureModel.class, new Object[]{"snapshotId", snapshotId});
        ArrayList<Violation> violations = new ArrayList<Violation>();
        for (RuleFailureModel model : models) {
            Violation violation = Violation.create((Rule)model.getRule(), (Resource)resource);
            violation.setLineId(model.getLine());
            violation.setMessage(model.getMessage());
            violation.setPriority(model.getPriority());
            violation.setCost(model.getCost());
            violations.add(violation);
        }
        return violations;
    }

    public void saveViolation(Snapshot snapshot, Violation violation) {
        if (this.profile == null || snapshot == null || violation == null || violation.getRule() == null) {
            throw new IllegalArgumentException("Missing data to save violation : profile=" + this.profile + ",snapshot=" + snapshot + ",violation=" + violation);
        }
        ActiveRule activeRule = this.profile.getActiveRule(violation.getRule());
        if (activeRule == null) {
            if (this.reuseExistingRulesConfig) {
                activeRule = new ActiveRule(this.profile, violation.getRule(), violation.getRule().getPriority());
            } else {
                LoggerFactory.getLogger(this.getClass()).debug("Violation is not saved because rule is not activated : violation={}", (Object)violation);
            }
        }
        if (activeRule != null) {
            RuleFailureModel model = this.toModel(snapshot, violation, activeRule);
            this.session.save((Object)model);
        }
    }

    private RuleFailureModel toModel(Snapshot snapshot, Violation violation, ActiveRule activeRule) {
        Rule rule = this.reload(violation.getRule());
        if (rule == null) {
            throw new IllegalArgumentException("Rule does not exist : " + violation.getRule());
        }
        RuleFailureModel model = new RuleFailureModel(rule, activeRule.getPriority());
        violation.setPriority(activeRule.getPriority());
        model.setLine(violation.getLineId());
        model.setMessage(violation.getMessage());
        model.setCost(violation.getCost());
        model.setSnapshotId(snapshot.getId());
        return model;
    }

    private Rule reload(Rule rule) {
        return rule.getId() != null ? rule : this.rulesDao.getRuleByKey(rule.getPluginName(), rule.getKey());
    }
}

