/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.indexer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Event;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.database.model.SnapshotSource;
import org.sonar.api.design.Dependency;
import org.sonar.api.design.DependencyDto;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectLink;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rules.Violation;
import org.sonar.batch.DefaultResourceCreationLock;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.ViolationsDao;
import org.sonar.batch.indexer.Bucket;
import org.sonar.batch.indexer.ResourcePersisters;
import org.sonar.jpa.dao.MeasuresDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSonarIndex
extends SonarIndex {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSonarIndex.class);
    private DatabaseSession session;
    private ResourcePersisters resourcePersisters;
    private Bucket<Project> rootProjectBucket;
    private Bucket<Project> selectedProjectBucket;
    private DefaultResourceCreationLock lock;
    private ViolationFilters violationFilters;
    private ResourceFilters resourceFilters;
    private Map<Resource, Bucket> buckets = Maps.newHashMap();
    private Set<Dependency> dependencies = Sets.newHashSet();
    private Map<Resource, Map<Resource, Dependency>> outgoingDependenciesByResource = new HashMap<Resource, Map<Resource, Dependency>>();
    private Map<Resource, Map<Resource, Dependency>> incomingDependenciesByResource = new HashMap<Resource, Map<Resource, Dependency>>();
    private ViolationsDao violationsDao;
    private MeasuresDao measuresDao;
    private ProjectTree projectTree;

    public DefaultSonarIndex(DatabaseSession session, ProjectTree projectTree, DefaultResourceCreationLock lock) {
        this.session = session;
        this.projectTree = projectTree;
        this.resourcePersisters = new ResourcePersisters(session);
        this.lock = lock;
    }

    public void start() {
        Project rootProject = this.projectTree.getRootProject();
        this.rootProjectBucket = new Bucket<Project>(rootProject);
        this.persist(this.rootProjectBucket);
        this.buckets.put((Resource)rootProject, this.rootProjectBucket);
        this.selectedProjectBucket = this.rootProjectBucket;
        for (Project project : rootProject.getModules()) {
            this.addProject(project);
        }
        this.session.commit();
    }

    private void addProject(Project project) {
        this.addResource((Resource)project);
        for (Project module : project.getModules()) {
            this.addProject(module);
        }
    }

    public void selectProject(Project project, ResourceFilters resourceFilters, ViolationFilters violationFilters, MeasuresDao measuresDao, ViolationsDao violationsDao) {
        this.selectedProjectBucket = this.buckets.get(project);
        this.resourceFilters = resourceFilters;
        this.violationFilters = violationFilters;
        this.violationsDao = violationsDao;
        this.measuresDao = measuresDao;
    }

    public void clear() {
        Iterator<Map.Entry<Resource, Bucket>> it = this.buckets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Resource, Bucket> entry = it.next();
            Resource resource = entry.getKey();
            if (ResourceUtils.isSet((Resource)resource)) continue;
            entry.getValue().clear();
            it.remove();
        }
        Set<Dependency> projectDependencies = this.getDependenciesBetweenProjects();
        this.dependencies.clear();
        this.incomingDependenciesByResource.clear();
        this.outgoingDependenciesByResource.clear();
        for (Dependency projectDependency : projectDependencies) {
            projectDependency.setId(null);
            this.registerDependency(projectDependency);
        }
        this.lock.unlock();
    }

    public Project getRootProject() {
        return this.rootProjectBucket.getResource();
    }

    public Project getProject() {
        return this.selectedProjectBucket.getResource();
    }

    public Bucket getBucket(Resource resource) {
        return this.buckets.get(resource);
    }

    public Resource getResource(Resource resource) {
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null) {
            return bucket.getResource();
        }
        return null;
    }

    public List<Resource> getChildren(Resource resource) {
        ArrayList children = Lists.newArrayList();
        Bucket bucket = this.buckets.get(resource);
        if (bucket != null) {
            for (Bucket<?> childBucket : bucket.getChildren()) {
                children.add(childBucket.getResource());
            }
        }
        return children;
    }

    public Resource addResource(Resource resource) {
        return this.getOrCreateBucket(resource, false).getResource();
    }

    private Bucket<Resource> getOrCreateBucket(Resource resource, boolean mustExist) {
        Bucket<Resource> bucket = this.buckets.get(resource);
        if (bucket != null) {
            return bucket;
        }
        if (mustExist && this.lock.isLocked() && !ResourceUtils.isLibrary((Resource)resource)) {
            LOG.warn("The following resource has not been registered before saving violation/measure/event: " + resource);
        }
        this.prepareResource(resource);
        bucket = new Bucket<Resource>(resource);
        this.buckets.put(resource, bucket);
        Bucket<Resource> parentBucket = null;
        Resource parent = resource.getParent();
        if (parent != null) {
            parentBucket = this.getOrCreateBucket(parent, mustExist);
        } else if (!ResourceUtils.isLibrary((Resource)resource)) {
            parentBucket = this.selectedProjectBucket;
        }
        bucket.setParent(parentBucket);
        bucket.setProject(this.selectedProjectBucket);
        this.persist(bucket);
        return bucket;
    }

    private void prepareResource(Resource resource) {
        resource.setExcluded(this.resourceFilters != null && this.resourceFilters.isExcluded(resource));
    }

    private void persist(Bucket bucket) {
        this.resourcePersisters.get(bucket).persist(bucket);
    }

    public Measure getMeasure(Resource resource, Metric metric) {
        return (Measure)this.getOrCreateBucket(resource, false).getMeasures(MeasuresFilters.metric((Metric)metric));
    }

    public <M> M getMeasures(Resource resource, MeasuresFilter<M> filter) {
        return this.getOrCreateBucket(resource, false).getMeasures(filter);
    }

    public void setSource(Resource resource, String source) {
        Bucket<Resource> bucket = this.getOrCreateBucket(resource, false);
        if (!bucket.isExcluded()) {
            if (bucket.isSourceSaved()) {
                LOG.warn("Trying to save twice the source of " + resource);
            } else {
                this.session.save((Object)new SnapshotSource(bucket.getSnapshotId(), source));
                bucket.setSourceSaved(true);
            }
        }
    }

    public void addViolation(Violation violation) {
        Resource resource = violation.getResource();
        Bucket<Object> bucket = resource == null ? this.selectedProjectBucket : this.getOrCreateBucket(resource, true);
        if (!bucket.isExcluded()) {
            this.persistViolation(violation, bucket.getSnapshot());
        }
    }

    private void persistViolation(Violation violation, Snapshot snapshot) {
        boolean isIgnored;
        boolean bl = isIgnored = this.violationFilters != null && this.violationFilters.isIgnored(violation);
        if (!isIgnored) {
            this.violationsDao.saveViolation(snapshot, violation);
        }
    }

    public Measure saveMeasure(Resource resource, Measure measure) {
        if (measure.getId() == null) {
            return this.addMeasure(resource, measure);
        }
        return this.updateMeasure(measure);
    }

    public Measure addMeasure(Resource resource, Measure measure) {
        Bucket<Resource> bucket = this.getOrCreateBucket(resource, true);
        if (!bucket.isExcluded()) {
            if (bucket.getMeasures(MeasuresFilters.measure((Measure)measure)) != null) {
                throw new IllegalArgumentException("This measure has already been saved: " + measure + ",resource: " + resource);
            }
            if (this.shouldPersistMeasure(resource, measure)) {
                this.persistMeasure(bucket, measure);
            }
            if (measure.getPersistenceMode().useMemory()) {
                bucket.addMeasure(measure);
            }
        }
        return measure;
    }

    public Measure updateMeasure(Measure measure) {
        if (measure.getId() == null) {
            throw new IllegalStateException("Measure can not be updated because it has never been saved");
        }
        MeasureModel model = (MeasureModel)this.session.reattach(MeasureModel.class, (Object)measure.getId());
        model = MeasureModel.build((Measure)measure, (MeasureModel)model);
        model.setMetric(this.measuresDao.getMetric(measure.getMetric()));
        model.save(this.session);
        return measure;
    }

    private void persistMeasure(Bucket bucket, Measure measure) {
        Metric metric = this.measuresDao.getMetric(measure.getMetric());
        MeasureModel measureModel = MeasureModel.build((Measure)measure);
        measureModel.setMetric(metric);
        measureModel.setSnapshotId(bucket.getSnapshotId());
        measureModel.save(this.session);
        measure.setId(measureModel.getId());
    }

    private boolean shouldPersistMeasure(Resource resource, Measure measure) {
        Metric metric = measure.getMetric();
        return measure.getPersistenceMode().useDatabase() && (!ResourceUtils.isEntity((Resource)resource) || metric.isOptimizedBestValue() != Boolean.TRUE || metric.getBestValue() == null || !metric.getBestValue().equals(measure.getValue()) || measure.hasOptionalData());
    }

    public Dependency saveDependency(Dependency dependency) {
        Dependency persistedDep = this.getEdge(dependency.getFrom(), dependency.getTo());
        if (persistedDep != null && persistedDep.getId() != null) {
            return persistedDep;
        }
        Bucket<Resource> from = this.getOrCreateBucket(dependency.getFrom(), true);
        Bucket<Resource> to = this.getOrCreateBucket(dependency.getTo(), true);
        DependencyDto dto = new DependencyDto();
        dto.setFromResourceId(from.getResourceId());
        dto.setFromScope(from.getResource().getScope());
        dto.setFromSnapshotId(from.getSnapshotId());
        dto.setToResourceId(to.getResourceId());
        dto.setToSnapshotId(to.getSnapshotId());
        dto.setToScope(to.getResource().getScope());
        dto.setProjectSnapshotId(this.selectedProjectBucket.getSnapshotId());
        dto.setUsage(dependency.getUsage());
        dto.setWeight(Integer.valueOf(dependency.getWeight()));
        Dependency parentDependency = dependency.getParent();
        if (parentDependency != null) {
            this.saveDependency(parentDependency);
            dto.setParentDependencyId(parentDependency.getId());
        }
        this.session.save((Object)dto);
        dependency.setId(dto.getId());
        this.registerDependency(dependency);
        return dependency;
    }

    protected void registerDependency(Dependency dependency) {
        this.dependencies.add(dependency);
        this.registerOutgoingDependency(dependency);
        this.registerIncomingDependency(dependency);
    }

    private void registerOutgoingDependency(Dependency dependency) {
        Map<Resource, Dependency> outgoingDeps = this.outgoingDependenciesByResource.get(dependency.getFrom());
        if (outgoingDeps == null) {
            outgoingDeps = new HashMap<Resource, Dependency>();
            this.outgoingDependenciesByResource.put(dependency.getFrom(), outgoingDeps);
        }
        outgoingDeps.put(dependency.getTo(), dependency);
    }

    private void registerIncomingDependency(Dependency dependency) {
        Map<Resource, Dependency> incomingDeps = this.incomingDependenciesByResource.get(dependency.getTo());
        if (incomingDeps == null) {
            incomingDeps = new HashMap<Resource, Dependency>();
            this.incomingDependenciesByResource.put(dependency.getTo(), incomingDeps);
        }
        incomingDeps.put(dependency.getFrom(), dependency);
    }

    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void saveLink(ProjectLink link) {
        ResourceModel projectDao = (ResourceModel)this.session.reattach(ResourceModel.class, (Object)this.selectedProjectBucket.getResourceId());
        ProjectLink dbLink = projectDao.getProjectLink(link.getKey());
        if (dbLink == null) {
            link.setResource(projectDao);
            projectDao.getProjectLinks().add(link);
            this.session.save((Object)link);
        } else {
            dbLink.copyFieldsFrom(link);
            this.session.save((Object)dbLink);
        }
    }

    public void deleteLink(String key) {
        ResourceModel projectDao = (ResourceModel)this.session.reattach(ResourceModel.class, (Object)this.selectedProjectBucket.getResourceId());
        ProjectLink dbLink = projectDao.getProjectLink(key);
        if (dbLink != null) {
            this.session.remove((Object)dbLink);
            projectDao.getProjectLinks().remove(dbLink);
        }
    }

    public List<Event> getEvents(Resource resource) {
        Bucket<Resource> bucket = this.getOrCreateBucket(resource, true);
        return this.session.getResults(Event.class, new Object[]{"resourceId", bucket.getResourceId()});
    }

    public void deleteEvent(Event event) {
        this.session.remove((Object)event);
    }

    public Event createEvent(Resource resource, String name, String description, String category, Date date) {
        Bucket<Resource> bucket = this.getOrCreateBucket(resource, true);
        Event event = date == null ? new Event(name, description, category, bucket.getSnapshot()) : new Event(name, description, category, date, bucket.getResourceId());
        return (Event)this.session.save((Object)event);
    }

    public Dependency getEdge(Resource from, Resource to) {
        Map<Resource, Dependency> map = this.outgoingDependenciesByResource.get(from);
        if (map != null) {
            return map.get(to);
        }
        return null;
    }

    public boolean hasEdge(Resource from, Resource to) {
        return this.getEdge(from, to) != null;
    }

    public Set<Resource> getVertices() {
        return this.buckets.keySet();
    }

    public Collection<Dependency> getOutgoingEdges(Resource from) {
        Map<Resource, Dependency> deps = this.outgoingDependenciesByResource.get(from);
        if (deps != null) {
            return deps.values();
        }
        return Collections.emptyList();
    }

    public Collection<Dependency> getIncomingEdges(Resource to) {
        Map<Resource, Dependency> deps = this.incomingDependenciesByResource.get(to);
        if (deps != null) {
            return deps.values();
        }
        return Collections.emptyList();
    }

    public Set<Dependency> getDependenciesBetweenProjects() {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (Project project : this.projectTree.getProjects()) {
            Collection deps = this.getOutgoingDependencies((Resource)project);
            for (Dependency dep : deps) {
                if (!ResourceUtils.isSet((Resource)dep.getTo())) continue;
                result.add(dep);
            }
        }
        return result;
    }
}

