/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.PostJob;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.batch.CoreJob;
import org.sonar.batch.MavenPluginExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostJobsExecutor
implements CoreJob {
    private static final Logger LOG = LoggerFactory.getLogger(PostJobsExecutor.class);
    private Collection<PostJob> postJobs;
    private MavenPluginExecutor mavenExecutor;

    public PostJobsExecutor(Project project, BatchExtensionDictionnary selector, MavenPluginExecutor mavenExecutor) {
        this.postJobs = selector.select(PostJob.class, project, true);
        this.mavenExecutor = mavenExecutor;
    }

    protected PostJobsExecutor(Collection<PostJob> postJobs, MavenPluginExecutor mavenExecutor) {
        this.postJobs = postJobs;
        this.mavenExecutor = mavenExecutor;
    }

    @Override
    public void execute(Project project, SensorContext context) {
        if (this.shouldExecuteOn(project)) {
            this.logPostJobs();
            for (PostJob postJob : this.postJobs) {
                LOG.info("Executing post-job {}", postJob.getClass());
                this.executeMavenPlugin(project, postJob);
                postJob.executeOn(project, context);
            }
        }
    }

    private void logPostJobs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Post-jobs : {}", (Object)StringUtils.join(this.postJobs, (String)" -> "));
        }
    }

    private boolean shouldExecuteOn(Project project) {
        return this.postJobs != null && project.isRoot();
    }

    private void executeMavenPlugin(Project project, PostJob job) {
        MavenPluginHandler handler;
        if (job instanceof DependsUponMavenPlugin && (handler = ((DependsUponMavenPlugin)job).getMavenPluginHandler(project)) != null) {
            this.mavenExecutor.execute(project, handler);
        }
    }
}

