/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.indexer;

import java.util.Date;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Library;
import org.sonar.batch.indexer.Bucket;
import org.sonar.batch.indexer.ResourcePersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryPersister
extends ResourcePersister<Library> {
    private Date now;

    public LibraryPersister(DatabaseSession session) {
        super(session);
        this.now = new Date();
    }

    LibraryPersister(DatabaseSession session, Date now) {
        super(session);
        this.now = now;
    }

    @Override
    protected String generateEffectiveKey(Bucket<Library> bucket) {
        return bucket.getResource().getKey();
    }

    @Override
    protected void prepareResourceModel(ResourceModel resourceModel, Bucket<Library> bucket) {
    }

    @Override
    protected Snapshot createSnapshot(Bucket<Library> bucket, ResourceModel resourceModel) {
        Snapshot snapshot = (Snapshot)this.getSession().getSingleResult(Snapshot.class, new Object[]{"resourceId", resourceModel.getId(), "version", bucket.getResource().getVersion(), "scope", "PRJ", "qualifier", "LIB"});
        if (snapshot == null) {
            snapshot = new Snapshot(resourceModel, null);
            snapshot.setCreatedAt(this.now);
            snapshot.setVersion(bucket.getResource().getVersion());
            snapshot.setStatus("P");
        }
        return snapshot;
    }
}

