/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.ResourceFilter;
import org.sonar.api.resources.Resource;

public class ResourceFilters {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceFilters.class);
    private ResourceFilter[] filters;

    public ResourceFilters(ResourceFilter[] filters) {
        this.filters = filters == null ? new ResourceFilter[]{} : filters;
    }

    public ResourceFilters() {
        this(null);
    }

    public ResourceFilter[] getFilters() {
        return this.filters;
    }

    public boolean isExcluded(Resource resource) {
        boolean ignored = false;
        for (int index = 0; !ignored && index < this.filters.length; ++index) {
            ResourceFilter filter = this.filters[index];
            ignored = filter.isIgnored(resource);
            if (!ignored || !LOG.isDebugEnabled()) continue;
            LOG.debug("Resource {} is excluded by the filter {}", (Object)resource, (Object)filter);
        }
        return ignored;
    }
}

