/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.sonar.api.Plugins;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.ServerHttpClient;
import org.sonar.batch.DefaultResourceCreationLock;
import org.sonar.batch.ProjectConfigurator;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.bootstrap.BatchExtensionInstaller;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrap.ProjectFilter;
import org.sonar.batch.bootstrap.ProjectModule;
import org.sonar.batch.components.PastMeasuresLoader;
import org.sonar.batch.components.PastSnapshotFinder;
import org.sonar.batch.components.PastSnapshotFinderByDate;
import org.sonar.batch.components.PastSnapshotFinderByDays;
import org.sonar.batch.components.PastSnapshotFinderByPreviousAnalysis;
import org.sonar.batch.components.PastSnapshotFinderByVersion;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.DefaultPersistenceManager;
import org.sonar.batch.index.DefaultResourcePersister;
import org.sonar.batch.index.DependencyPersister;
import org.sonar.batch.index.EventPersister;
import org.sonar.batch.index.LinkPersister;
import org.sonar.batch.index.MeasurePersister;
import org.sonar.batch.index.MemoryOptimizer;
import org.sonar.batch.index.ReadOnlyPersistenceManager;
import org.sonar.batch.index.SourcePersister;
import org.sonar.core.components.CacheMetricFinder;
import org.sonar.core.components.CacheRuleFinder;
import org.sonar.core.components.DefaultUserFinder;
import org.sonar.core.notifications.DefaultNotificationManager;
import org.sonar.jpa.dao.MeasuresDao;

public class BatchModule
extends Module {
    private final boolean dryRun;

    public BatchModule(boolean dryRun) {
        this.dryRun = dryRun;
    }

    protected void configure() {
        this.addCoreSingleton(ProjectTree.class);
        this.addCoreSingleton(ProjectFilter.class);
        this.addCoreSingleton(ProjectConfigurator.class);
        this.addCoreSingleton(DefaultResourceCreationLock.class);
        this.addCoreSingleton(DefaultIndex.class);
        if (this.dryRun) {
            this.addCoreSingleton(ReadOnlyPersistenceManager.class);
        } else {
            this.addCoreSingleton(DefaultPersistenceManager.class);
            this.addCoreSingleton(DependencyPersister.class);
            this.addCoreSingleton(EventPersister.class);
            this.addCoreSingleton(LinkPersister.class);
            this.addCoreSingleton(MeasurePersister.class);
            this.addCoreSingleton(MemoryOptimizer.class);
            this.addCoreSingleton(DefaultResourcePersister.class);
            this.addCoreSingleton(SourcePersister.class);
        }
        this.addCoreSingleton(Plugins.class);
        this.addCoreSingleton(ServerHttpClient.class);
        this.addCoreSingleton(MeasuresDao.class);
        this.addCoreSingleton(CacheRuleFinder.class);
        this.addCoreSingleton(CacheMetricFinder.class);
        this.addCoreSingleton(PastSnapshotFinderByDate.class);
        this.addCoreSingleton(PastSnapshotFinderByDays.class);
        this.addCoreSingleton(PastSnapshotFinderByPreviousAnalysis.class);
        this.addCoreSingleton(PastSnapshotFinderByVersion.class);
        this.addCoreSingleton(PastMeasuresLoader.class);
        this.addCoreSingleton(PastSnapshotFinder.class);
        this.addCoreSingleton(DefaultNotificationManager.class);
        this.addCoreSingleton(DefaultUserFinder.class);
        this.addCoreMetrics();
        this.addBatchExtensions();
    }

    private void addBatchExtensions() {
        BatchExtensionInstaller installer = this.getComponentByType(BatchExtensionInstaller.class);
        installer.install(this);
    }

    void addCoreMetrics() {
        for (Metric metric : CoreMetrics.getMetrics()) {
            this.addCoreSingleton(metric);
        }
    }

    protected void doStart() {
        ProjectTree projectTree = this.getComponentByType(ProjectTree.class);
        this.analyze(projectTree.getRootProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyze(Project project) {
        for (Project subProject : project.getModules()) {
            this.analyze(subProject);
        }
        Module projectComponents = this.installChild(new ProjectModule(project, this.dryRun));
        try {
            projectComponents.start();
        }
        finally {
            projectComponents.stop();
            this.uninstallChild();
        }
    }
}

