/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.Plugin;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.resources.Project;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.DryRun;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrapper.EnvironmentInformation;

public final class ProjectExtensionInstaller
implements BatchComponent {
    private BatchPluginRepository pluginRepository;
    private EnvironmentInformation environment;
    private DryRun dryRun;

    public ProjectExtensionInstaller(BatchPluginRepository pluginRepository, EnvironmentInformation environment, DryRun dryRun) {
        this.pluginRepository = pluginRepository;
        this.environment = environment;
        this.dryRun = dryRun;
    }

    public void install(Module module, Project project) {
        for (Map.Entry<String, Plugin> entry : this.pluginRepository.getPluginsByKey().entrySet()) {
            for (Object extension : entry.getValue().getExtensions()) {
                this.installExtension(module, extension, project, entry.getKey());
            }
        }
        this.installExtensionProviders(module, project);
    }

    void installExtensionProviders(Module module, Project project) {
        List<ExtensionProvider> providers = module.getComponents(ExtensionProvider.class);
        for (ExtensionProvider provider : providers) {
            Object obj = provider.provide();
            if (obj instanceof Iterable) {
                for (Object extension : (Iterable)obj) {
                    this.installExtension(module, extension, project, "");
                }
                continue;
            }
            this.installExtension(module, obj, project, "");
        }
    }

    private Object installExtension(Module module, Object extension, Project project, String pluginKey) {
        if (ExtensionUtils.isBatchExtension(extension) && ExtensionUtils.isSupportedEnvironment(extension, this.environment) && ExtensionUtils.isInstantiationStrategy(extension, "PER_PROJECT") && ExtensionUtils.checkDryRun(extension, this.dryRun.isEnabled()) && !ProjectExtensionInstaller.isDeactivatedCoverageExtension(extension, project, pluginKey) && !ProjectExtensionInstaller.isMavenExtensionOnEmulatedMavenProject(extension, project)) {
            module.addComponent(extension);
            return extension;
        }
        return null;
    }

    static boolean isMavenExtensionOnEmulatedMavenProject(Object extension, Project project) {
        return ExtensionUtils.isMavenExtensionOnly(extension) && project.getPom() == null;
    }

    static boolean isDeactivatedCoverageExtension(Object extension, Project project, String pluginKey) {
        if (!ExtensionUtils.isType(extension, CoverageExtension.class)) {
            return false;
        }
        if (!project.getAnalysisType().isDynamic(true)) {
            return true;
        }
        if (StringUtils.equals((String)project.getLanguageKey(), (String)"java")) {
            Object[] selectedPluginKeys = project.getConfiguration().getStringArray("sonar.core.codeCoveragePlugin");
            if (ArrayUtils.isEmpty((Object[])selectedPluginKeys)) {
                selectedPluginKeys = new String[]{"cobertura"};
            }
            return !ArrayUtils.contains((Object[])selectedPluginKeys, (Object)pluginKey);
        }
        return false;
    }
}

