/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.sonar.api.Plugins;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.ServerHttpClient;
import org.sonar.batch.DefaultResourceCreationLock;
import org.sonar.batch.ProjectConfiguration;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.bootstrap.BatchExtensionInstaller;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrap.ProjectModule;
import org.sonar.batch.components.PastMeasuresLoader;
import org.sonar.batch.components.PastSnapshotFinder;
import org.sonar.batch.components.PastSnapshotFinderByDate;
import org.sonar.batch.components.PastSnapshotFinderByDays;
import org.sonar.batch.components.PastSnapshotFinderByPreviousAnalysis;
import org.sonar.batch.components.PastSnapshotFinderByVersion;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.DefaultPersistenceManager;
import org.sonar.batch.index.DefaultResourcePersister;
import org.sonar.batch.index.DependencyPersister;
import org.sonar.batch.index.EventPersister;
import org.sonar.batch.index.LinkPersister;
import org.sonar.batch.index.MeasurePersister;
import org.sonar.batch.index.MemoryOptimizer;
import org.sonar.batch.index.ReadOnlyPersistenceManager;
import org.sonar.batch.index.SourcePersister;
import org.sonar.core.components.CacheMetricFinder;
import org.sonar.core.components.CacheRuleFinder;
import org.sonar.core.components.DefaultUserFinder;
import org.sonar.core.notifications.DefaultNotificationManager;
import org.sonar.jpa.dao.MeasuresDao;

public class BatchModule
extends Module {
    private final boolean dryRun;

    public BatchModule(boolean dryRun) {
        this.dryRun = dryRun;
    }

    protected void configure() {
        this.addComponent(ProjectConfiguration.class);
        this.addComponent(ProjectTree.class);
        this.addComponent(DefaultResourceCreationLock.class);
        this.addComponent(DefaultIndex.class);
        if (this.dryRun) {
            this.addComponent(ReadOnlyPersistenceManager.class);
        } else {
            this.addComponent(DefaultPersistenceManager.class);
            this.addComponent(DependencyPersister.class);
            this.addComponent(EventPersister.class);
            this.addComponent(LinkPersister.class);
            this.addComponent(MeasurePersister.class);
            this.addComponent(MemoryOptimizer.class);
            this.addComponent(DefaultResourcePersister.class);
            this.addComponent(SourcePersister.class);
        }
        this.addComponent(Plugins.class);
        this.addComponent(ServerHttpClient.class);
        this.addComponent(MeasuresDao.class);
        this.addComponent(CacheRuleFinder.class);
        this.addComponent(CacheMetricFinder.class);
        this.addComponent(PastSnapshotFinderByDate.class);
        this.addComponent(PastSnapshotFinderByDays.class);
        this.addComponent(PastSnapshotFinderByPreviousAnalysis.class);
        this.addComponent(PastSnapshotFinderByVersion.class);
        this.addComponent(PastMeasuresLoader.class);
        this.addComponent(PastSnapshotFinder.class);
        this.addComponent(DefaultNotificationManager.class);
        this.addComponent(DefaultUserFinder.class);
        this.addCoreMetrics();
        this.addBatchExtensions();
    }

    private void addBatchExtensions() {
        BatchExtensionInstaller installer = this.getComponent(BatchExtensionInstaller.class);
        installer.install(this);
    }

    void addCoreMetrics() {
        for (Metric metric : CoreMetrics.getMetrics()) {
            this.addComponent(metric.getKey(), metric);
        }
    }

    protected void doStart() {
        ProjectTree projectTree = this.getComponent(ProjectTree.class);
        this.analyze(projectTree.getRootProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyze(Project project) {
        for (Project subProject : project.getModules()) {
            this.analyze(subProject);
        }
        Module projectComponents = this.installChild(new ProjectModule(project, this.dryRun));
        try {
            projectComponents.start();
        }
        finally {
            projectComponents.stop();
            this.uninstallChild(projectComponents);
        }
    }
}

