/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectBuilder;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.resources.Project;
import org.sonar.batch.ProjectConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTree {
    private ProjectConfigurator configurator;
    private ProjectReactor projectReactor;
    private List<Project> projects;
    private Map<ProjectDefinition, Project> projectsByDef;

    public ProjectTree(ProjectReactor projectReactor, DatabaseSession databaseSession, ProjectBuilder[] builders) {
        this(projectReactor, databaseSession);
    }

    public ProjectTree(ProjectReactor projectReactor, DatabaseSession databaseSession) {
        this.configurator = new ProjectConfigurator(databaseSession);
        this.projectReactor = projectReactor;
    }

    ProjectTree(ProjectConfigurator configurator) {
        this.configurator = configurator;
    }

    public void start() throws IOException {
        this.doStart(this.projectReactor.getProjects());
    }

    void doStart(List<ProjectDefinition> definitions) {
        this.projects = Lists.newArrayList();
        this.projectsByDef = Maps.newHashMap();
        for (ProjectDefinition projectDefinition : definitions) {
            Project project = this.configurator.create(projectDefinition);
            this.projectsByDef.put(projectDefinition, project);
            this.projects.add(project);
        }
        for (Map.Entry entry : this.projectsByDef.entrySet()) {
            ProjectDefinition def = (ProjectDefinition)entry.getKey();
            Project project = (Project)entry.getValue();
            for (ProjectDefinition module : def.getSubProjects()) {
                this.projectsByDef.get(module).setParent(project);
            }
        }
        for (Map.Entry entry : this.projectsByDef.entrySet()) {
            this.configurator.configure((Project)entry.getValue(), (ProjectDefinition)entry.getKey());
        }
        this.applyExclusions();
    }

    void applyExclusions() {
        for (Project project : this.projects) {
            String[] excludedArtifactIds = project.getConfiguration().getStringArray("sonar.skippedModules");
            String[] includedArtifactIds = project.getConfiguration().getStringArray("sonar.includedModules");
            HashSet<String> includedModulesIdSet = new HashSet<String>();
            HashSet<String> excludedModulesIdSet = new HashSet<String>();
            if (includedArtifactIds != null) {
                includedModulesIdSet.addAll(Arrays.asList(includedArtifactIds));
            }
            if (excludedArtifactIds != null) {
                excludedModulesIdSet.addAll(Arrays.asList(excludedArtifactIds));
                includedModulesIdSet.removeAll(excludedModulesIdSet);
            }
            if (!includedModulesIdSet.isEmpty()) {
                for (Project currentProject : this.projects) {
                    if (includedModulesIdSet.contains(this.getArtifactId(currentProject))) continue;
                    this.exclude(currentProject);
                }
                continue;
            }
            for (String excludedArtifactId : excludedModulesIdSet) {
                Project excludedProject = this.getProjectByArtifactId(excludedArtifactId);
                this.exclude(excludedProject);
            }
        }
        Iterator<Project> it = this.projects.iterator();
        while (it.hasNext()) {
            Project project;
            project = it.next();
            if (!project.isExcluded()) continue;
            LoggerFactory.getLogger(this.getClass()).info("Module {} is excluded from analysis", (Object)project.getName());
            project.removeFromParent();
            it.remove();
        }
    }

    private void exclude(Project project) {
        if (project != null) {
            project.setExcluded(true);
            for (Project module : project.getModules()) {
                this.exclude(module);
            }
        }
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    private String getArtifactId(Project project) {
        String key = project.getKey();
        if (StringUtils.isNotBlank((String)project.getBranch())) {
            key = StringUtils.removeEnd((String)project.getKey(), (String)(":" + project.getBranch()));
        }
        return StringUtils.substringAfterLast((String)key, (String)":");
    }

    public Project getProjectByArtifactId(String artifactId) {
        for (Project project : this.projects) {
            if (!StringUtils.equals((String)this.getArtifactId(project), (String)artifactId)) continue;
            return project;
        }
        return null;
    }

    public Project getRootProject() {
        for (Project project : this.projects) {
            if (project.getParent() != null) continue;
            return project;
        }
        throw new IllegalStateException("Can not find the root project from the list of Maven modules");
    }

    public ProjectDefinition getProjectDefinition(Project project) {
        for (Map.Entry<ProjectDefinition, Project> entry : this.projectsByDef.entrySet()) {
            if (!ObjectUtils.equals((Object)entry.getValue(), (Object)project)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Can not find ProjectDefinition for " + project);
    }
}

