/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.ProjectConfiguration;

public class ProjectConfigurator {
    private DatabaseSession databaseSession;

    public ProjectConfigurator(DatabaseSession databaseSession) {
        this.databaseSession = databaseSession;
    }

    public Project create(ProjectDefinition definition) {
        Configuration configuration = this.getStartupConfiguration(definition);
        Project project = new Project(definition.getKey(), this.loadProjectBranch(configuration), definition.getName()).setDescription(StringUtils.defaultString((String)definition.getDescription(), (String)"")).setPackaging("jar");
        for (Object component : definition.getContainerExtensions()) {
            if (!(component instanceof MavenProject)) continue;
            MavenProject pom = (MavenProject)component;
            project.setPom(pom);
            project.setPackaging(pom.getPackaging());
        }
        return project;
    }

    Configuration getStartupConfiguration(ProjectDefinition project) {
        CompositeConfiguration configuration = new CompositeConfiguration();
        configuration.addConfiguration((Configuration)new SystemConfiguration());
        configuration.addConfiguration((Configuration)new EnvironmentConfiguration());
        configuration.addConfiguration((Configuration)new MapConfiguration((Map)project.getProperties()));
        return configuration;
    }

    String loadProjectBranch(Configuration configuration) {
        return configuration.getString("sonar.branch");
    }

    public void configure(Project project, ProjectDefinition def) {
        ProjectConfiguration projectConfiguration = new ProjectConfiguration(this.databaseSession, def);
        this.configure(project, (Configuration)projectConfiguration);
    }

    void configure(Project project, Configuration projectConfiguration) {
        Date analysisDate = this.loadAnalysisDate(projectConfiguration);
        project.setConfiguration(projectConfiguration).setExclusionPatterns(ProjectConfigurator.loadExclusionPatterns(projectConfiguration)).setAnalysisDate(analysisDate).setLatestAnalysis(this.isLatestAnalysis(project.getKey(), analysisDate)).setAnalysisVersion(this.loadAnalysisVersion(projectConfiguration)).setAnalysisType(this.loadAnalysisType(projectConfiguration)).setLanguageKey(this.loadLanguageKey(projectConfiguration));
    }

    static String[] loadExclusionPatterns(Configuration configuration) {
        String[] exclusionPatterns = configuration.getStringArray("sonar.exclusions");
        if (exclusionPatterns == null) {
            exclusionPatterns = new String[]{};
        }
        for (int i = 0; i < exclusionPatterns.length; ++i) {
            exclusionPatterns[i] = StringUtils.trim((String)exclusionPatterns[i]);
        }
        return exclusionPatterns;
    }

    boolean isLatestAnalysis(String projectKey, Date analysisDate) {
        ResourceModel persistedProject = (ResourceModel)this.databaseSession.getSingleResult(ResourceModel.class, new Object[]{"key", projectKey, "enabled", true});
        if (persistedProject != null) {
            Snapshot lastSnapshot = (Snapshot)this.databaseSession.getSingleResult(Snapshot.class, new Object[]{"resourceId", persistedProject.getId(), "last", true});
            return lastSnapshot == null || lastSnapshot.getCreatedAt().before(analysisDate);
        }
        return true;
    }

    Date loadAnalysisDate(Configuration configuration) {
        String formattedDate = configuration.getString("sonar.projectDate");
        if (formattedDate == null) {
            return new Date();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = DateUtils.setHours((Date)format.parse(formattedDate), (int)0);
            return DateUtils.setMinutes((Date)date, (int)1);
        }
        catch (ParseException e) {
            throw new SonarException("The property sonar.projectDate does not respect the format yyyy-MM-dd (for example 2008-05-23) : " + formattedDate, (Throwable)e);
        }
    }

    Project.AnalysisType loadAnalysisType(Configuration configuration) {
        String value = configuration.getString("sonar.dynamicAnalysis");
        if (value == null) {
            return configuration.getBoolean("sonar.light", false) ? Project.AnalysisType.STATIC : Project.AnalysisType.DYNAMIC;
        }
        if ("true".equals(value)) {
            return Project.AnalysisType.DYNAMIC;
        }
        if ("reuseReports".equals(value)) {
            return Project.AnalysisType.REUSE_REPORTS;
        }
        return Project.AnalysisType.STATIC;
    }

    String loadAnalysisVersion(Configuration configuration) {
        return configuration.getString("sonar.projectVersion");
    }

    String loadLanguageKey(Configuration configuration) {
        return configuration.getString("sonar.language", "java");
    }
}

