/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.codehaus.plexus.util.xml.SerializerXMLWriter;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class Xpp3Dom
implements Serializable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String CHILDREN_COMBINATION_MODE_ATTRIBUTE = "combine.children";
    public static final String CHILDREN_COMBINATION_MERGE = "merge";
    public static final String CHILDREN_COMBINATION_APPEND = "append";
    public static final String DEFAULT_CHILDREN_COMBINATION_MODE = "merge";
    public static final String SELF_COMBINATION_MODE_ATTRIBUTE = "combine.self";
    public static final String SELF_COMBINATION_OVERRIDE = "override";
    public static final String SELF_COMBINATION_MERGE = "merge";
    public static final String SELF_COMBINATION_REMOVE = "remove";
    public static final String DEFAULT_SELF_COMBINATION_MODE = "merge";
    public static final String ID_COMBINATION_MODE_ATTRIBUTE = "combine.id";
    public static final String KEYS_COMBINATION_MODE_ATTRIBUTE = "combine.keys";
    private ChildrenTracking childrenTracking;
    private XmlNode dom;

    public Xpp3Dom(String name) {
        this.dom = new XmlNodeImpl(name);
    }

    public Xpp3Dom(String name, Object inputLocation) {
        this.dom = new XmlNodeImpl(name, null, null, null, inputLocation);
    }

    public Xpp3Dom(Xpp3Dom src) {
        this(src, src.getName());
    }

    public Xpp3Dom(Xpp3Dom src, String name) {
        this.dom = new XmlNodeImpl(src.dom, name);
    }

    public Xpp3Dom(XmlNode dom) {
        this.dom = dom;
    }

    public Xpp3Dom(XmlNode dom, Xpp3Dom parent) {
        this.dom = dom;
        this.childrenTracking = parent::replace;
    }

    public Xpp3Dom(XmlNode dom, ChildrenTracking childrenTracking) {
        this.dom = dom;
        this.childrenTracking = childrenTracking;
    }

    public XmlNode getDom() {
        return this.dom;
    }

    public String getName() {
        return this.dom.getName();
    }

    public String getValue() {
        return this.dom.getValue();
    }

    public void setValue(String value) {
        this.update((XmlNode)new XmlNodeImpl(this.dom.getName(), value, this.dom.getAttributes(), this.dom.getChildren(), this.dom.getInputLocation()));
    }

    public String[] getAttributeNames() {
        return this.dom.getAttributes().keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public String getAttribute(String name) {
        return this.dom.getAttribute(name);
    }

    public boolean removeAttribute(String name) {
        if (name != null && !name.isEmpty()) {
            boolean ret;
            HashMap attrs = new HashMap(this.dom.getAttributes());
            boolean bl = ret = attrs.remove(name) != null;
            if (ret) {
                this.update((XmlNode)new XmlNodeImpl(this.dom.getName(), this.dom.getValue(), attrs, this.dom.getChildren(), this.dom.getInputLocation()));
            }
            return ret;
        }
        return false;
    }

    public void setAttribute(String name, String value) {
        if (null == value) {
            throw new NullPointerException("Attribute value can not be null");
        }
        if (null == name) {
            throw new NullPointerException("Attribute name can not be null");
        }
        HashMap<String, String> attrs = new HashMap<String, String>(this.dom.getAttributes());
        attrs.put(name, value);
        this.update((XmlNode)new XmlNodeImpl(this.dom.getName(), this.dom.getValue(), attrs, this.dom.getChildren(), this.dom.getInputLocation()));
    }

    public Xpp3Dom getChild(int i) {
        return new Xpp3Dom((XmlNode)this.dom.getChildren().get(i), this);
    }

    public Xpp3Dom getChild(String name) {
        XmlNode child = this.dom.getChild(name);
        return child != null ? new Xpp3Dom(child, this) : null;
    }

    public void addChild(Xpp3Dom xpp3Dom) {
        ArrayList<XmlNode> children = new ArrayList<XmlNode>(this.dom.getChildren());
        children.add(xpp3Dom.dom);
        xpp3Dom.childrenTracking = this::replace;
        this.update((XmlNode)new XmlNodeImpl(this.dom.getName(), this.dom.getValue(), this.dom.getAttributes(), children, this.dom.getInputLocation()));
    }

    public Xpp3Dom[] getChildren() {
        return (Xpp3Dom[])this.dom.getChildren().stream().map(d -> new Xpp3Dom((XmlNode)d, this)).toArray(Xpp3Dom[]::new);
    }

    public Xpp3Dom[] getChildren(String name) {
        return (Xpp3Dom[])this.dom.getChildren().stream().filter(c -> c.getName().equals(name)).map(d -> new Xpp3Dom((XmlNode)d, this)).toArray(Xpp3Dom[]::new);
    }

    public int getChildCount() {
        return this.dom.getChildren().size();
    }

    public void removeChild(int i) {
        ArrayList children = new ArrayList(this.dom.getChildren());
        children.remove(i);
        this.update((XmlNode)new XmlNodeImpl(this.dom.getName(), this.dom.getValue(), this.dom.getAttributes(), children, this.dom.getInputLocation()));
    }

    public void removeChild(Xpp3Dom child) {
        ArrayList children = new ArrayList(this.dom.getChildren());
        children.remove(child.dom);
        this.update((XmlNode)new XmlNodeImpl(this.dom.getName(), this.dom.getValue(), this.dom.getAttributes(), children, this.dom.getInputLocation()));
    }

    public Xpp3Dom getParent() {
        throw new UnsupportedOperationException();
    }

    public void setParent(Xpp3Dom parent) {
    }

    public Object getInputLocation() {
        return this.dom.getInputLocation();
    }

    public void setInputLocation(Object inputLocation) {
        this.update((XmlNode)new XmlNodeImpl(this.dom.getName(), this.dom.getValue(), this.dom.getAttributes(), this.dom.getChildren(), inputLocation));
    }

    public void writeToSerializer(String namespace, XmlSerializer serializer) throws IOException {
        SerializerXMLWriter xmlWriter = new SerializerXMLWriter(namespace, serializer);
        Xpp3DomWriter.write(xmlWriter, this);
        if (xmlWriter.getExceptions().size() > 0) {
            throw (IOException)xmlWriter.getExceptions().get(0);
        }
    }

    private static void mergeIntoXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        if (recessive == null) {
            return;
        }
        dominant.dom = dominant.dom.merge(recessive.dom, childMergeOverride);
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        if (dominant != null) {
            Xpp3Dom.mergeIntoXpp3Dom(dominant, recessive, childMergeOverride);
            return dominant;
        }
        return recessive;
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive) {
        if (dominant != null) {
            Xpp3Dom.mergeIntoXpp3Dom(dominant, recessive, null);
            return dominant;
        }
        return recessive;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Xpp3Dom)) {
            return false;
        }
        Xpp3Dom dom = (Xpp3Dom)obj;
        return this.dom.equals(dom.dom);
    }

    public int hashCode() {
        return this.dom.hashCode();
    }

    public String toString() {
        return this.dom.toString();
    }

    public String toUnescapedString() {
        return ((Xpp3Dom)this.dom).toUnescapedString();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private void update(XmlNode dom) {
        if (this.childrenTracking != null) {
            this.childrenTracking.replace(this.dom, dom);
        }
        this.dom = dom;
    }

    private boolean replace(Object prevChild, Object newChild) {
        ArrayList children = new ArrayList(this.dom.getChildren());
        children.replaceAll(d -> d == prevChild ? (XmlNode)newChild : d);
        this.update((XmlNode)new XmlNodeImpl(this.dom.getName(), this.dom.getValue(), this.dom.getAttributes(), children, this.dom.getInputLocation()));
        return true;
    }

    public void setChildrenTracking(ChildrenTracking childrenTracking) {
        this.childrenTracking = childrenTracking;
    }

    @FunctionalInterface
    public static interface ChildrenTracking {
        public boolean replace(Object var1, Object var2);
    }
}

