/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.StreamFeeder;
import org.codehaus.plexus.util.cli.StreamPumper;

public abstract class CommandLineUtils {
    public static int executeCommandLine(Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCommandLine(Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        if (cl == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        Process p = cl.execute();
        StreamFeeder inputFeeder = null;
        if (systemIn != null) {
            inputFeeder = new StreamFeeder(systemIn, p.getOutputStream());
        }
        StreamPumper outputPumper = new StreamPumper(p.getInputStream(), systemOut);
        StreamPumper errorPumper = new StreamPumper(p.getErrorStream(), systemErr);
        if (inputFeeder != null) {
            inputFeeder.start();
        }
        outputPumper.start();
        errorPumper.start();
        try {
            Thread thread;
            int returnValue = p.waitFor();
            if (inputFeeder != null) {
                thread = inputFeeder;
                synchronized (thread) {
                    if (!inputFeeder.isDone()) {
                        inputFeeder.wait();
                    }
                }
            }
            if (outputPumper != null) {
                thread = outputPumper;
                synchronized (thread) {
                    if (!outputPumper.isDone()) {
                        outputPumper.wait();
                    }
                }
            }
            if (errorPumper != null) {
                thread = errorPumper;
                synchronized (thread) {
                    if (!errorPumper.isDone()) {
                        errorPumper.wait();
                    }
                }
            }
            int n = returnValue;
            Object var14_15 = null;
            if (inputFeeder != null) {
                inputFeeder.close();
            }
            outputPumper.close();
            errorPumper.close();
            return n;
        }
        catch (InterruptedException ex) {
            try {
                throw new CommandLineException("Error while executing external command.", ex);
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (inputFeeder != null) {
                    inputFeeder.close();
                }
                outputPumper.close();
                errorPumper.close();
                throw throwable;
            }
        }
    }

    public static Properties getSystemEnvVars() throws IOException {
        String line;
        Process p = null;
        Properties envVars = new Properties();
        Runtime r = Runtime.getRuntime();
        String os = System.getProperty("os.name").toLowerCase();
        p = os.indexOf("windows") != -1 ? (os.indexOf("95") != -1 || os.indexOf("98") != -1 || os.indexOf("Me") != -1 ? r.exec("command.com /c set") : r.exec("cmd.exe /c set")) : r.exec("env");
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = br.readLine()) != null) {
            int idx = line.indexOf(61);
            String key = line.substring(0, idx);
            String value = line.substring(idx + 1);
            envVars.setProperty(key, value);
        }
        return envVars;
    }

    public static class StringStreamConsumer
    implements StreamConsumer {
        private StringBuffer string = new StringBuffer();
        private String ls = System.getProperty("line.separator");

        public void consumeLine(String line) {
            this.string.append(line + this.ls);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

