/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.manager;

import com.google.common.base.ReferenceType;
import com.google.common.collect.ReferenceMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.manager.AbstractComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.lifecycle.LifecycleHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerLookupComponentManager<T>
extends AbstractComponentManager<T> {
    private boolean disposed;
    private final Map<T, T> instances = new ReferenceMap(ReferenceType.WEAK, ReferenceType.WEAK);

    public PerLookupComponentManager(MutablePlexusContainer container, LifecycleHandler lifecycleHandler, ComponentDescriptor<T> componentDescriptor) {
        super(container, lifecycleHandler, componentDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() throws ComponentLifecycleException {
        Set<T> instances;
        PerLookupComponentManager perLookupComponentManager = this;
        synchronized (perLookupComponentManager) {
            this.disposed = true;
            instances = this.instances.keySet();
            this.instances.clear();
        }
        ComponentLifecycleException componentLifecycleException = null;
        for (T instance : instances) {
            try {
                this.destroyInstance(instance);
            }
            catch (ComponentLifecycleException e) {
                if (componentLifecycleException != null) continue;
                componentLifecycleException = e;
            }
        }
        if (componentLifecycleException == null) {
            throw componentLifecycleException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getComponent() throws ComponentInstantiationException, ComponentLifecycleException {
        PerLookupComponentManager perLookupComponentManager = this;
        synchronized (perLookupComponentManager) {
            if (this.disposed) {
                throw new ComponentLifecycleException("This ComponentManager has already been destroyed");
            }
        }
        Object instance = this.createInstance();
        PerLookupComponentManager perLookupComponentManager2 = this;
        synchronized (perLookupComponentManager2) {
            if (this.disposed) {
                try {
                    this.destroyInstance(instance);
                }
                catch (ComponentLifecycleException componentLifecycleException) {
                    // empty catch block
                }
                throw new ComponentLifecycleException("This ComponentManager has already been destroyed");
            }
            this.instances.put(instance, instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Object component) throws ComponentLifecycleException {
        T instance;
        PerLookupComponentManager perLookupComponentManager = this;
        synchronized (perLookupComponentManager) {
            instance = this.instances.remove(component);
        }
        if (instance != null) {
            this.destroyInstance(component);
        }
    }
}

