/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xbean.recipe.AbstractRecipe;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.RecipeHelper;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.CastUtils;
import org.codehaus.plexus.component.ComponentStack;
import org.codehaus.plexus.component.MapOrientedComponent;
import org.codehaus.plexus.component.builder.ComponentBuildListener;
import org.codehaus.plexus.component.builder.ComponentBuilder;
import org.codehaus.plexus.component.collections.LiveList;
import org.codehaus.plexus.component.collections.LiveMap;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.MapConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;
import org.codehaus.plexus.component.configurator.expression.DefaultExpressionEvaluator;
import org.codehaus.plexus.component.factory.ComponentFactory;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.factory.UndefinedComponentFactoryException;
import org.codehaus.plexus.component.factory.java.JavaComponentFactory;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.PhaseExecutionException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XBeanComponentBuilder<T>
implements ComponentBuilder<T> {
    private ComponentManager<T> componentManager;

    public XBeanComponentBuilder() {
    }

    public XBeanComponentBuilder(ComponentManager<T> componentManager) {
        this.setComponentManager(componentManager);
    }

    public ComponentManager<T> getComponentManager() {
        return this.componentManager;
    }

    public void setComponentManager(ComponentManager<T> componentManager) {
        this.componentManager = componentManager;
    }

    protected MutablePlexusContainer getContainer() {
        return this.componentManager.getContainer();
    }

    @Override
    public T build(ComponentDescriptor<T> descriptor, ClassRealm realm, ComponentBuildListener listener) throws ComponentInstantiationException, ComponentLifecycleException {
        if (listener != null) {
            listener.beforeComponentCreate(descriptor, realm);
        }
        T component = this.createComponentInstance(descriptor, realm);
        if (listener != null) {
            listener.componentCreated(descriptor, component, realm);
        }
        this.startComponentLifecycle(component, realm);
        if (listener != null) {
            listener.componentConfigured(descriptor, component, realm);
        }
        return component;
    }

    protected T createComponentInstance(ComponentDescriptor<T> descriptor, ClassRealm realm) throws ComponentInstantiationException {
        MutablePlexusContainer container = this.getContainer();
        if (realm == null) {
            realm = descriptor.getRealm();
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)realm);
        try {
            Object instance;
            ObjectRecipe recipe = this.createObjectRecipe(descriptor, realm);
            ComponentFactory componentFactory = container.getComponentFactoryManager().findComponentFactory(descriptor.getComponentFactory());
            if (JavaComponentFactory.class.equals(componentFactory.getClass())) {
                instance = recipe.create();
            } else {
                instance = componentFactory.newInstance(descriptor, realm, container);
                recipe.setProperties(instance);
            }
            if (instance instanceof MapOrientedComponent) {
                MapOrientedComponent mapOrientedComponent = (MapOrientedComponent)instance;
                this.processMapOrientedComponent(descriptor, mapOrientedComponent, realm);
            }
            Object object = instance;
            return (T)object;
        }
        catch (ConstructionException e) {
            Throwable cause = XBeanComponentBuilder.unwrapConstructionException(e);
            if (cause instanceof ComponentInstantiationException) {
                throw (ComponentInstantiationException)cause;
            }
            if (cause != null) {
                throw new ComponentInstantiationException(e.getMessage(), cause);
            }
            throw new ComponentInstantiationException(e.getMessage());
        }
        catch (UndefinedComponentFactoryException e) {
            throw new ComponentInstantiationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public ObjectRecipe createObjectRecipe(ComponentDescriptor<T> descriptor, ClassRealm realm) throws ComponentInstantiationException {
        String factoryMethod = null;
        String[] constructorArgNames = null;
        Class[] constructorArgTypes = null;
        ObjectRecipe recipe = new ObjectRecipe(descriptor.getImplementationClass(), factoryMethod, constructorArgNames, constructorArgTypes);
        recipe.allow(Option.FIELD_INJECTION);
        recipe.allow(Option.PRIVATE_PROPERTIES);
        if (!MapOrientedComponent.class.isAssignableFrom(descriptor.getImplementationClass())) {
            PlexusConfiguration configuration;
            for (ComponentRequirement requirement : descriptor.getRequirements()) {
                String name = requirement.getFieldName();
                RequirementRecipe<T> requirementRecipe = new RequirementRecipe<T>(descriptor, requirement, this.getContainer(), name == null);
                if (name != null) {
                    recipe.setProperty(name, requirementRecipe);
                    continue;
                }
                recipe.setAutoMatchProperty(requirement.getRole(), requirementRecipe);
            }
            if (this.shouldConfigure(descriptor) && (configuration = descriptor.getConfiguration()) != null) {
                for (String name : configuration.getAttributeNames()) {
                    String value;
                    try {
                        value = configuration.getAttribute(name);
                    }
                    catch (PlexusConfigurationException e) {
                        throw new ComponentInstantiationException("Error getting value for attribute " + name, e);
                    }
                    name = this.fromXML(name);
                    recipe.setProperty(name, (Object)value);
                }
                for (PlexusConfiguration child : configuration.getChildren()) {
                    String name = child.getName();
                    name = this.fromXML(name);
                    if (child.getChildCount() > 0) {
                        recipe.setProperty(name, (Object)new PlexusConfigurationRecipe(child));
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((String)child.getValue())) continue;
                    recipe.setProperty(name, (Object)child.getValue());
                }
            }
        }
        return recipe;
    }

    protected boolean shouldConfigure(ComponentDescriptor<T> descriptor) {
        String configuratorId = descriptor.getComponentConfigurator();
        if (StringUtils.isEmpty((String)configuratorId)) {
            return true;
        }
        try {
            ComponentConfigurator componentConfigurator = this.getContainer().lookup(ComponentConfigurator.class, configuratorId);
            return componentConfigurator == null || componentConfigurator.getClass().equals(BasicComponentConfigurator.class);
        }
        catch (ComponentLookupException componentLookupException) {
            return true;
        }
    }

    protected String fromXML(String elementName) {
        return StringUtils.lowercaseFirstLetter((String)StringUtils.removeAndHump((String)elementName, (String)"-"));
    }

    protected void startComponentLifecycle(Object component, ClassRealm realm) throws ComponentLifecycleException {
        try {
            this.componentManager.start(component);
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof PhaseExecutionException && e.getCause() != null) {
                cause = e.getCause();
            }
            throw new ComponentLifecycleException("Error invoking start method", cause);
        }
    }

    private void processMapOrientedComponent(ComponentDescriptor<?> descriptor, MapOrientedComponent mapOrientedComponent, ClassRealm realm) throws ComponentInstantiationException {
        MutablePlexusContainer container = this.getContainer();
        for (ComponentRequirement requirement : descriptor.getRequirements()) {
            String role = requirement.getRole();
            String hint = requirement.getRoleHint();
            String mappingType = requirement.getFieldMappingType();
            try {
                Object value = StringUtils.isNotEmpty((String)hint) && !hint.equals("default") ? container.lookup(role, hint) : ("single".equals(mappingType) ? container.lookup(role, hint) : ("map".equals(mappingType) ? container.lookupMap(role) : ("set".equals(mappingType) ? new HashSet<Object>(container.lookupList(role)) : container.lookup(role, hint))));
                mapOrientedComponent.addComponentRequirement(requirement, value);
            }
            catch (ComponentLookupException e) {
                throw new ComponentInstantiationException("Error looking up requirement of MapOrientedComponent ", e);
            }
            catch (ComponentConfigurationException e) {
                throw new ComponentInstantiationException("Error adding requirement to MapOrientedComponent ", e);
            }
        }
        MapConverter converter = new MapConverter();
        DefaultConverterLookup converterLookup = new DefaultConverterLookup();
        DefaultExpressionEvaluator expressionEvaluator = new DefaultExpressionEvaluator();
        PlexusConfiguration configuration = container.getConfigurationSource().getConfiguration(descriptor);
        if (configuration != null) {
            try {
                Map context = (Map)converter.fromConfiguration(converterLookup, configuration, null, null, (ClassLoader)realm, expressionEvaluator, null);
                mapOrientedComponent.setComponentConfiguration(context);
            }
            catch (ComponentConfigurationException e) {
                throw new ComponentInstantiationException("Error adding configuration to MapOrientedComponent ", e);
            }
        }
    }

    private static Class<?> getInterfaceClass(PlexusContainer container, String role, String hint) {
        if (hint == null) {
            hint = "default";
        }
        try {
            ClassRealm realm = container.getLookupRealm();
            if (realm != null) {
                return realm.loadClass(role);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                return loader.loadClass(role);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            ClassLoader loader;
            ComponentDescriptor<?> cd = container.getComponentDescriptor(role, hint);
            if (cd != null && (loader = cd.getImplementationClass().getClassLoader()) != null) {
                return loader.loadClass(role);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Object.class;
    }

    private static Throwable unwrapConstructionException(ConstructionException e) {
        Throwable cause = e;
        while (cause instanceof ConstructionException && e.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private class PlexusConfigurationRecipe
    extends AbstractRecipe {
        private final PlexusConfiguration child;

        public PlexusConfigurationRecipe(PlexusConfiguration child) {
            this.child = child;
        }

        public boolean canCreate(Type type) {
            try {
                ConverterLookup lookup = this.createConverterLookup();
                lookup.lookupConverterForType(RecipeHelper.toClass((Type)type));
                return true;
            }
            catch (ComponentConfigurationException e) {
                return false;
            }
        }

        protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
            ComponentStack.setComponentStackProperty(this.child.getName());
            try {
                Object value;
                ConverterLookup lookup = this.createConverterLookup();
                ConfigurationConverter converter = lookup.lookupConverterForType(RecipeHelper.toClass((Type)expectedType));
                ObjectRecipe caller = (ObjectRecipe)RecipeHelper.getCaller();
                Class parentClass = RecipeHelper.toClass((Type)caller.getType());
                Object object = value = converter.fromConfiguration(lookup, this.child, RecipeHelper.toClass((Type)expectedType), parentClass, Thread.currentThread().getContextClassLoader(), new DefaultExpressionEvaluator());
                return object;
            }
            catch (ComponentConfigurationException e) {
                throw new ConstructionException((Throwable)e);
            }
            finally {
                ComponentStack.setComponentStackProperty(null);
            }
        }

        private ConverterLookup createConverterLookup() {
            ClassRealm realm = (ClassRealm)Thread.currentThread().getContextClassLoader();
            DefaultConverterLookup lookup = new DefaultConverterLookup();
            lookup.registerConverter(new ClassRealmConverter(realm));
            return lookup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequirementRecipe<T>
    extends AbstractRecipe {
        private ComponentDescriptor<T> componentDescriptor;
        private ComponentRequirement requirement;
        private MutablePlexusContainer container;
        private boolean autoMatch;

        public RequirementRecipe(ComponentDescriptor<T> componentDescriptor, ComponentRequirement requirement, MutablePlexusContainer container, boolean autoMatch) {
            this.componentDescriptor = componentDescriptor;
            this.requirement = requirement;
            this.container = container;
            this.autoMatch = autoMatch;
        }

        public boolean canCreate(Type expectedType) {
            if (!this.autoMatch) {
                return true;
            }
            Class propertyType = RecipeHelper.toClass((Type)expectedType);
            if (propertyType.isArray() || Map.class.isAssignableFrom(propertyType) || Collection.class.isAssignableFrom(propertyType) || this.requirement instanceof ComponentRequirementList) {
                return false;
            }
            try {
                String roleHint = this.requirement.getRoleHint();
                Class roleType = XBeanComponentBuilder.getInterfaceClass(this.container, this.requirement.getRole(), roleHint);
                for (ComponentDescriptor descriptor : this.container.getComponentDescriptorList(roleType)) {
                    if (!descriptor.getRoleHint().equals(roleHint) || !CastUtils.isAssignableFrom(propertyType, descriptor.getImplementationClass())) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
            Class propertyType = RecipeHelper.toClass((Type)expectedType);
            ComponentStack.setComponentStackProperty(this.requirement.getFieldName());
            try {
                Object assignment;
                Class roleType = XBeanComponentBuilder.getInterfaceClass(this.container, this.requirement.getRole(), this.requirement.getRoleHint());
                List<String> roleHints = null;
                if (this.requirement instanceof ComponentRequirementList) {
                    roleHints = ((ComponentRequirementList)this.requirement).getRoleHints();
                }
                if (propertyType.isArray()) {
                    assignment = new ArrayList(this.container.lookupList(roleType, roleHints));
                } else if (Map.class.equals((Object)propertyType)) {
                    Class valueClass;
                    Object keyType = Object.class;
                    Object valueType = Object.class;
                    Type[] typeParameters = RecipeHelper.getTypeParameters(Collection.class, (Type)expectedType);
                    if (typeParameters != null && typeParameters.length == 2) {
                        if (typeParameters[0] instanceof Class) {
                            keyType = typeParameters[0];
                        }
                        if (typeParameters[1] instanceof Class) {
                            valueType = typeParameters[1];
                        }
                    }
                    if ((valueClass = RecipeHelper.toClass(valueType)).equals(Object.class)) {
                        valueClass = roleType;
                    }
                    assignment = new LiveMap(this.container, roleType, roleHints, this.componentDescriptor.getHumanReadableKey());
                } else if (List.class.equals((Object)propertyType)) {
                    Class componentClass;
                    Type[] typeParameters = RecipeHelper.getTypeParameters(Collection.class, (Type)expectedType);
                    Object componentType = Object.class;
                    if (typeParameters != null && typeParameters.length == 1 && typeParameters[0] instanceof Class) {
                        componentType = typeParameters[0];
                    }
                    if ((componentClass = RecipeHelper.toClass(componentType)).equals(Object.class)) {
                        componentClass = roleType;
                    }
                    assignment = new LiveList(this.container, roleType, roleHints, this.componentDescriptor.getHumanReadableKey());
                } else if (Set.class.equals((Object)propertyType) || Collection.class.isAssignableFrom(propertyType)) {
                    assignment = this.container.lookupMap(roleType, roleHints);
                } else if (Logger.class.equals((Object)propertyType)) {
                    assignment = this.container.getLoggerManager().getLoggerForComponent(this.componentDescriptor.getRole());
                } else if (PlexusContainer.class.equals((Object)propertyType)) {
                    assignment = this.container;
                } else {
                    String roleHint = this.requirement.getRoleHint();
                    assignment = this.container.lookup(roleType, roleHint);
                }
                ArrayList arrayList = assignment;
                return arrayList;
            }
            catch (ComponentLookupException e) {
                throw new ConstructionException((Throwable)e);
            }
            finally {
                ComponentStack.setComponentStackProperty(null);
            }
        }

        public String toString() {
            return "RequirementRecipe[fieldName=" + this.requirement.getFieldName() + ", role=" + this.componentDescriptor.getRole() + "]";
        }
    }
}

