/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.plexus.component.ComponentStackElement;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentStack {
    private static final ThreadLocal<LinkedList<ComponentStackElement>> STACK = new ThreadLocal<LinkedList<ComponentStackElement>>(){

        @Override
        protected LinkedList<ComponentStackElement> initialValue() {
            return new LinkedList<ComponentStackElement>();
        }
    };

    public static List<ComponentStackElement> getComponentStack() {
        LinkedList<ComponentStackElement> stack = STACK.get();
        ArrayList<ComponentStackElement> copy = new ArrayList<ComponentStackElement>(stack.size());
        for (ComponentStackElement element : stack) {
            copy.add(new ComponentStackElement(element));
        }
        return Collections.unmodifiableList(copy);
    }

    public static void pushComponentStack(ComponentDescriptor<?> descriptor) throws ComponentLookupException {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor is null");
        }
        LinkedList<ComponentStackElement> stack = STACK.get();
        for (ComponentStackElement element : stack) {
            if (!descriptor.equals(element.getDescriptor())) continue;
            stack.addFirst(new ComponentStackElement(descriptor));
            ComponentLookupException exception = new ComponentLookupException("Creation circularity", descriptor);
            stack.removeFirst();
            throw exception;
        }
        stack.addFirst(new ComponentStackElement(descriptor));
    }

    public static void popComponentStack() {
        STACK.get().removeFirst();
    }

    public static void setComponentStackProperty(String property) {
        LinkedList<ComponentStackElement> stackElementLinkedList = STACK.get();
        if (stackElementLinkedList.isEmpty()) {
            return;
        }
        ComponentStackElement element = stackElementLinkedList.getLast();
        element.setProperty(property);
    }

    private ComponentStack() {
    }
}

