/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentIndex<V> {
    private final boolean indexByAllTypes;
    private final Map<ClassLoader, SortedMap<Class<?>, Multimap<String, V>>> index = new LinkedHashMap();

    public ComponentIndex() {
        this(false);
    }

    public ComponentIndex(boolean indexByAllTypes) {
        this.indexByAllTypes = indexByAllTypes;
    }

    public boolean isIndexByAllTypes() {
        return this.indexByAllTypes;
    }

    public synchronized V get(Class<?> type, String roleHint) {
        return this.get(type, roleHint, Thread.currentThread().getContextClassLoader());
    }

    public synchronized V get(Class<?> type, String roleHint, ClassLoader classLoader) {
        Collection values;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (roleHint == null) {
            roleHint = "default";
        }
        if ((values = this.findAll(type, classLoader).get((Object)roleHint)).isEmpty()) {
            return null;
        }
        return (V)values.iterator().next();
    }

    public synchronized Collection<V> getAll() {
        ArrayList values = new ArrayList();
        for (SortedMap<Class<?>, Multimap<String, V>> roleIndex : this.index.values()) {
            for (Multimap<String, V> roleHintIndex : roleIndex.values()) {
                values.addAll(roleHintIndex.values());
            }
        }
        return values;
    }

    public synchronized List<V> getAll(Class<?> type) {
        return this.getAll(type, Thread.currentThread().getContextClassLoader());
    }

    public synchronized List<V> getAll(Class<?> type, ClassLoader classLoader) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        return new ArrayList(this.findAll(type, classLoader).values());
    }

    public synchronized Map<String, V> getAllAsMap(Class<?> type) {
        return this.getAllAsMap(type, Thread.currentThread().getContextClassLoader());
    }

    public synchronized Map<String, V> getAllAsMap(Class<?> type, ClassLoader classLoader) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        TreeMap descriptors = new TreeMap();
        for (Map.Entry entry : this.findAll(type, classLoader).entries()) {
            if (descriptors.containsKey(entry.getKey())) continue;
            descriptors.put(entry.getKey(), entry.getValue());
        }
        return descriptors;
    }

    private synchronized Multimap<String, V> findAll(Class<?> type, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = type.getClassLoader();
        }
        LinkedHashSet<Object> classLoaders = new LinkedHashSet<Object>();
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            if (!(cl instanceof ClassRealm)) continue;
            for (ClassRealm realm = (ClassRealm)cl; realm != null; realm = realm.getParentRealm()) {
                classLoaders.add(realm);
            }
        }
        if (classLoaders.isEmpty()) {
            classLoaders.addAll(this.index.keySet());
        }
        HashMultimap roleHintIndex = Multimaps.newHashMultimap();
        for (ClassLoader classLoader2 : classLoaders) {
            Multimap values;
            SortedMap<Class<?>, Multimap<String, V>> roleIndex = this.index.get(classLoader2);
            if (roleIndex == null || (values = (Multimap)roleIndex.get(type)) == null) continue;
            roleHintIndex.putAll(values);
        }
        return Multimaps.unmodifiableMultimap((Multimap)roleHintIndex);
    }

    public synchronized void add(ClassLoader classLoader, Class<?> type, String roleHint, V value) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (roleHint == null) {
            roleHint = "default";
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        SortedMap<Class<?>, Multimap<String, Multimap>> roleIndex = this.index.get(classLoader);
        if (roleIndex == null) {
            roleIndex = new TreeMap(ClassComparator.INSTANCE);
            this.index.put(classLoader, roleIndex);
        }
        for (Class<?> clazz : this.getAllTypes(type)) {
            Multimap roleHintIndex = (Multimap)roleIndex.get(clazz);
            if (roleHintIndex == null) {
                roleHintIndex = new ArrayListMultimap();
                roleIndex.put(clazz, roleHintIndex);
            }
            roleHintIndex.put((Object)roleHint, value);
        }
    }

    public synchronized void remove(V value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        for (SortedMap<Class<?>, Multimap<String, V>> roleIndex : this.index.values()) {
            for (Multimap<String, V> roleHintIndex : roleIndex.values()) {
                Iterator iterator = roleHintIndex.values().iterator();
                while (iterator.hasNext()) {
                    Object v = iterator.next();
                    if (!value.equals(v)) continue;
                    iterator.remove();
                }
            }
        }
    }

    public synchronized List<V> removeAll(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        ArrayList values = new ArrayList();
        SortedMap<Class<?>, Multimap<String, V>> roleIndex = this.index.remove(classLoader);
        for (Multimap<String, V> roleHintIndex : roleIndex.values()) {
            values.addAll(roleHintIndex.values());
        }
        return values;
    }

    public synchronized Collection<V> clear() {
        Collection<V> all = this.getAll();
        this.index.clear();
        return all;
    }

    private Set<Class<?>> getAllTypes(Class<?> type) {
        if (type.isArray()) {
            throw new IllegalArgumentException("type is an array: type=" + type);
        }
        if (!this.indexByAllTypes) {
            return Collections.singleton(type);
        }
        LinkedHashSet allTypes = new LinkedHashSet();
        LinkedList typesToProcess = new LinkedList();
        typesToProcess.add(type);
        while (!typesToProcess.isEmpty()) {
            Class clazz = (Class)typesToProcess.removeFirst();
            if (allTypes.contains(clazz)) continue;
            allTypes.add(clazz);
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                typesToProcess.addFirst(superclass);
            }
            typesToProcess.addAll(0, Arrays.asList(clazz.getInterfaces()));
        }
        return allTypes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClassComparator
    implements Comparator<Class<?>>,
    Serializable {
        private static final ClassComparator INSTANCE = new ClassComparator();

        private ClassComparator() {
        }

        @Override
        public int compare(Class<?> class1, Class<?> class2) {
            return class1.getName().compareTo(class2.getName());
        }
    }
}

