/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.deployment.ant.pack200;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.jdesktop.deployment.ant.pack200.PackUtils;

public class Pack200Task
extends Copy {
    public static final List MODIFICATION_TIME_VALUES = new ArrayList();
    public static final List DEFLATE_HINT_VALUES;
    public static final List UNKNOWN_ATTRIBUTE_VALUES;
    private boolean repack;
    private boolean gzip;
    private File config;
    private Map propMap = new HashMap();

    protected void validateAttributes() {
        String modificationTime;
        super.validateAttributes();
        if (this.config != null) {
            if (this.config.isDirectory()) {
                throw new BuildException("The pack200 property file specified is a directory: " + this.config, this.getLocation());
            }
            if (!this.config.exists()) {
                throw new BuildException("The pack200 property file specified doesn't exist: " + this.config, this.getLocation());
            }
            Properties properties = this.getPackProperties();
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> next;
                Map.Entry<Object, Object> entry = next = iterator.next();
                this.propMap.put(entry.getKey(), entry.getValue());
            }
        }
        if ((modificationTime = (String)this.propMap.get("pack.modification.time")) != null && !MODIFICATION_TIME_VALUES.contains(modificationTime)) {
            throw new BuildException(modificationTime + " is not a legal value for the modificationtime attribute", this.getLocation());
        }
        String deflateHint = (String)this.propMap.get("pack.deflate.hint");
        if (deflateHint != null && !DEFLATE_HINT_VALUES.contains(deflateHint)) {
            throw new BuildException(deflateHint + " is not a legal value for the deflatehint attribute", this.getLocation());
        }
        String unknownAttribute = (String)this.propMap.get("pack.unknown.attribute");
        if (unknownAttribute != null && !UNKNOWN_ATTRIBUTE_VALUES.contains(unknownAttribute)) {
            throw new BuildException(deflateHint + " is not a legal value for the unknownattribute attribute", this.getLocation());
        }
    }

    public void setSrc(File src) {
        this.setFile(src);
    }

    public void setDestfile(File destFile) {
        this.setTofile(destFile);
    }

    public void setRepack(boolean value) {
        this.repack = value;
    }

    public void setGZIPOutput(boolean value) {
        this.gzip = value;
    }

    public void setStripDebug(boolean value) {
        this.propMap.put("com.sun.java.util.jar.pack.strip.debug", String.valueOf(value));
    }

    public void setModificationTime(String value) {
        this.propMap.put("pack.modification.time", value);
    }

    public void setDeflateHint(String value) {
        this.propMap.put("pack.deflate.hint", value);
    }

    public void setKeepFileOrder(boolean value) {
        this.propMap.put("pack.keep.file.order", String.valueOf(value));
    }

    public void setSegmentLimit(int value) {
        this.propMap.put("pack.segment.limit", String.valueOf(value));
    }

    public void setEffort(int value) {
        this.propMap.put("pack.effort", String.valueOf(value));
    }

    public void setUnknownAttribute(String value) {
        this.propMap.put("pack.unknown.attribute", value);
    }

    public void setConfigFile(File config) {
        this.config = config;
    }

    public void execute() {
        if (this.mapperElement == null && !this.repack) {
            GlobPatternMapper mapper = new GlobPatternMapper();
            mapper.setFrom("*.jar");
            mapper.setTo("*.jar.pack" + (this.gzip ? ".gz" : ""));
            this.add((FileNameMapper)mapper);
        }
        super.execute();
    }

    protected Properties getPackProperties() {
        Properties properties = new Properties();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(this.config));
            properties.load(in);
        }
        catch (IOException e) {
            try {
                throw new BuildException("Could not load the pack200 properties file: " + this.config, (Throwable)e, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(in);
                throw throwable;
            }
        }
        FileUtils.close((InputStream)in);
        return properties;
    }

    protected void doFileOperations() {
        if (this.fileCopyMap.size() > 0) {
            this.log((this.repack ? "Repacking " : "Packing ") + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Enumeration e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                for (int i = 0; i < toFiles.length; ++i) {
                    String toFile = toFiles[i];
                    if (!this.repack && fromFile.equals(toFile)) {
                        this.log("Skipping self-pack of " + fromFile, this.verbosity);
                        continue;
                    }
                    try {
                        this.log((this.repack ? "Repacking " : "Packing ") + fromFile + " to " + toFile, this.verbosity);
                        if (this.repack) {
                            PackUtils.repack(new File(fromFile), new File(toFile), this.propMap);
                            continue;
                        }
                        boolean gzip = this.gzip || toFile.endsWith(".gz");
                        PackUtils.pack(new File(fromFile), new File(toFile), this.propMap, gzip);
                        continue;
                    }
                    catch (IOException ioe) {
                        String msg = "Failed to pack " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = msg + " and I couldn't delete the corrupt " + toFile;
                        }
                        throw new BuildException(msg, (Throwable)ioe, this.getLocation());
                    }
                }
            }
        }
    }

    static {
        MODIFICATION_TIME_VALUES.add("latest");
        MODIFICATION_TIME_VALUES.add("keep");
        DEFLATE_HINT_VALUES = new ArrayList();
        DEFLATE_HINT_VALUES.add("true");
        DEFLATE_HINT_VALUES.add("false");
        DEFLATE_HINT_VALUES.add("keep");
        UNKNOWN_ATTRIBUTE_VALUES = new ArrayList();
        UNKNOWN_ATTRIBUTE_VALUES.add("error");
        UNKNOWN_ATTRIBUTE_VALUES.add("strip");
        UNKNOWN_ATTRIBUTE_VALUES.add("pass");
    }
}

