/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogSystem;
import org.codehaus.mojo.webstart.JnlpMojo;

public class Generator {
    private VelocityEngine engine = new VelocityEngine();
    private JnlpMojo config;
    private Template template;
    private File outputFile;

    public Generator(JnlpMojo task, File resourceLoaderPath, File outputFile, String inputFileTemplatePath) {
        this.config = task;
        this.outputFile = outputFile;
        Properties props = new Properties();
        props.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
        props.setProperty("file.resource.loader.path", resourceLoaderPath.getAbsolutePath());
        try {
            this.engine.setProperty("runtime.log.logsystem", (Object)new NullLogSystem());
            this.engine.init(props);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not initialise Velocity");
            iae.initCause(e);
            throw iae;
        }
        if (!this.engine.templateExists(inputFileTemplatePath)) {
            System.out.println("Template not found!! ");
        }
        try {
            this.template = this.engine.getTemplate(inputFileTemplatePath);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Could not load the template file from '" + inputFileTemplatePath + "'");
            iae.initCause(e);
            throw iae;
        }
    }

    public void generate() throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("dependencies", (Object)Generator.getDependenciesText(this.config));
        context.put("outputFile", (Object)this.outputFile.getName());
        context.put("mainClass", (Object)this.config.getJnlp().getMainClass());
        FileWriter writer = new FileWriter(this.outputFile);
        try {
            this.template.merge((Context)context, (Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new Exception("Could not generate the template " + this.template.getName() + ": " + e.getMessage(), e);
        }
        finally {
            writer.close();
        }
    }

    static String getDependenciesText(JnlpMojo config) {
        String dependenciesText = "";
        List artifacts = config.getPackagedJnlpArtifacts();
        if (artifacts.size() != 0) {
            StringBuffer buffer = new StringBuffer(100 * artifacts.size());
            buffer.append("\n");
            for (int i = 0; i < artifacts.size(); ++i) {
                Artifact artifact = (Artifact)artifacts.get(i);
                buffer.append("<jar href=\"").append(artifact.getFile().getName()).append("\"");
                if (config.isArtifactWithMainClass(artifact)) {
                    buffer.append(" main=\"true\"");
                }
                buffer.append("/>\n");
            }
            dependenciesText = buffer.toString();
        }
        return dependenciesText;
    }
}

