/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.jardiff;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import jnlp.sample.jardiff.JarDiff;
import jnlp.sample.jardiff.JarDiffConstants;
import jnlp.sample.jardiff.Patcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarDiffPatcher
implements JarDiffConstants,
Patcher {
    private static final int DEFAULT_READ_SIZE = 2048;
    private static byte[] newBytes = new byte[2048];
    private static byte[] oldBytes = new byte[2048];
    private static ResourceBundle _resources = JarDiff.getResources();

    public static ResourceBundle getResources() {
        return JarDiff.getResources();
    }

    @Override
    public void applyPatch(Patcher.PatchDelegate delegate, String oldJarPath, String jarDiffPath, OutputStream result) throws IOException {
        File oldFile = new File(oldJarPath);
        File diffFile = new File(jarDiffPath);
        JarOutputStream jos = new JarOutputStream(result);
        JarFile oldJar = new JarFile(oldFile);
        JarFile jarDiff = new JarFile(diffFile);
        HashSet<String> ignoreSet = new HashSet<String>();
        HashMap<String, String> renameMap = new HashMap<String, String>();
        this.determineNameMapping(jarDiff, ignoreSet, renameMap);
        String[] keys = renameMap.keySet().toArray(new String[renameMap.size()]);
        HashSet<String> oldjarNames = new HashSet<String>();
        Enumeration<JarEntry> oldEntries = oldJar.entries();
        if (oldEntries != null) {
            while (oldEntries.hasMoreElements()) {
                oldjarNames.add(oldEntries.nextElement().getName());
            }
        }
        double size = oldjarNames.size() + keys.length + jarDiff.size();
        double currentEntry = 0.0;
        oldjarNames.removeAll(ignoreSet);
        size -= (double)ignoreSet.size();
        Enumeration<JarEntry> entries = jarDiff.entries();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!"META-INF/INDEX.JD".equals(entry.getName())) {
                    this.updateDelegate(delegate, currentEntry, size);
                    currentEntry += 1.0;
                    this.writeEntry(jos, entry, jarDiff);
                    boolean wasInOld = oldjarNames.remove(entry.getName());
                    if (!wasInOld) continue;
                    size -= 1.0;
                    continue;
                }
                size -= 1.0;
            }
        }
        for (String newName : keys) {
            String oldName = (String)renameMap.get(newName);
            JarEntry oldEntry = oldJar.getJarEntry(oldName);
            if (oldEntry == null) {
                String moveCmd = "move" + oldName + " " + newName;
                this.handleException("jardiff.error.badmove", moveCmd);
            }
            JarEntry newEntry = new JarEntry(newName);
            newEntry.setTime(oldEntry.getTime());
            newEntry.setSize(oldEntry.getSize());
            newEntry.setCompressedSize(oldEntry.getCompressedSize());
            newEntry.setCrc(oldEntry.getCrc());
            newEntry.setMethod(oldEntry.getMethod());
            newEntry.setExtra(oldEntry.getExtra());
            newEntry.setComment(oldEntry.getComment());
            this.updateDelegate(delegate, currentEntry, size);
            currentEntry += 1.0;
            this.writeEntry(jos, newEntry, oldJar.getInputStream(oldEntry));
            boolean wasInOld = oldjarNames.remove(oldName);
            if (!wasInOld) continue;
            size -= 1.0;
        }
        for (String name : oldjarNames) {
            JarEntry entry = oldJar.getJarEntry(name);
            this.updateDelegate(delegate, currentEntry, size);
            currentEntry += 1.0;
            this.writeEntry(jos, entry, oldJar);
        }
        this.updateDelegate(delegate, currentEntry, size);
        jos.finish();
    }

    private void updateDelegate(Patcher.PatchDelegate delegate, double currentSize, double size) {
        if (delegate != null) {
            delegate.patching((int)(currentSize / size));
        }
    }

    private void determineNameMapping(JarFile jarDiff, Set<String> ignoreSet, Map<String, String> renameMap) throws IOException {
        LineNumberReader indexReader;
        String line;
        InputStream is = jarDiff.getInputStream(jarDiff.getEntry("META-INF/INDEX.JD"));
        if (is == null) {
            this.handleException("jardiff.error.noindex", null);
        }
        if ((line = (indexReader = new LineNumberReader(new InputStreamReader(is, "UTF-8"))).readLine()) == null || !line.equals("version 1.0")) {
            this.handleException("jardiff.error.badheader", line);
        }
        while ((line = indexReader.readLine()) != null) {
            List<String> sub;
            if (line.startsWith("remove")) {
                sub = this.getSubpaths(line.substring("remove".length()));
                if (sub.size() != 1) {
                    this.handleException("jardiff.error.badremove", line);
                }
                ignoreSet.add(sub.get(0));
                continue;
            }
            if (line.startsWith("move")) {
                sub = this.getSubpaths(line.substring("move".length()));
                if (sub.size() != 2) {
                    this.handleException("jardiff.error.badmove", line);
                }
                if (renameMap.put(sub.get(1), sub.get(0)) == null) continue;
                this.handleException("jardiff.error.badmove", line);
                continue;
            }
            if (line.length() <= 0) continue;
            this.handleException("jardiff.error.badcommand", line);
        }
    }

    private void handleException(String errorMsg, String line) throws IOException {
        try {
            throw new IOException(JarDiffPatcher.getResources().getString(errorMsg) + " " + line);
        }
        catch (MissingResourceException mre) {
            System.err.println("Fatal error: " + errorMsg);
            new Throwable().printStackTrace(System.err);
            System.exit(-1);
            return;
        }
    }

    private List<String> getSubpaths(String path) {
        int index = 0;
        int length = path.length();
        ArrayList<String> sub = new ArrayList<String>();
        while (index < length) {
            int start;
            while (index < length && Character.isWhitespace(path.charAt(index))) {
                ++index;
            }
            if (index >= length) continue;
            int last = start = index;
            String subString = null;
            while (index < length) {
                char aChar = path.charAt(index);
                if (aChar == '\\' && index + 1 < length && path.charAt(index + 1) == ' ') {
                    subString = subString == null ? path.substring(last, index) : subString + path.substring(last, index);
                    last = ++index;
                } else if (Character.isWhitespace(aChar)) break;
                ++index;
            }
            if (last != index) {
                subString = subString == null ? path.substring(last, index) : subString + path.substring(last, index);
            }
            sub.add(subString);
        }
        return sub;
    }

    private void writeEntry(JarOutputStream jos, JarEntry entry, JarFile file) throws IOException {
        this.writeEntry(jos, entry, file.getInputStream(entry));
    }

    private void writeEntry(JarOutputStream jos, JarEntry entry, InputStream data) throws IOException {
        jos.putNextEntry(new ZipEntry(entry.getName()));
        int size = data.read(newBytes);
        while (size != -1) {
            jos.write(newBytes, 0, size);
            size = data.read(newBytes);
        }
        data.close();
    }
}

