/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.model.Build;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.model.io.stax.CoreExtensionsStaxReader;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ExtensionBuilder;
import org.codehaus.mojo.versions.utils.ModelNode;

public final class ExtensionUtils {
    private ExtensionUtils() {
    }

    public static Stream<Extension> getCoreExtensions(MavenProject project) throws IOException, XMLStreamException {
        Path extensionsFile = project.getBasedir().toPath().resolve(".mvn/extensions.xml");
        if (!Files.isRegularFile(extensionsFile, new LinkOption[0])) {
            return Stream.empty();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(extensionsFile, new OpenOption[0])));){
            Stream<Extension> stream = new CoreExtensionsStaxReader().read(reader).getExtensions().stream().map(ex -> ExtensionBuilder.newBuilder().withGroupId(ex.getGroupId()).withArtifactId(ex.getArtifactId()).withVersion(ex.getVersion()).build());
            return stream;
        }
    }

    public static Stream<Extension> getBuildExtensions(MavenProject project, Log log, boolean interpolateProperties) throws XMLStreamException, IOException, TransformerException {
        if (interpolateProperties) {
            return ExtensionUtils.getInterpolatedBuildExtensions(project, log);
        }
        return PomHelper.getChildModels(project, log).values().stream().map(Model::getBuild).filter(Objects::nonNull).map(Build::getExtensions).map(Collection::stream).reduce(Stream::concat).orElse(Stream.empty());
    }

    private static Stream<Extension> getInterpolatedBuildExtensions(MavenProject project, Log log) throws IOException, XMLStreamException, TransformerException {
        MutableXMLStreamReader pomReader = new MutableXMLStreamReader(project.getFile().toPath());
        ModelNode rootNode = new ModelNode(PomHelper.getRawModel(pomReader.getSource(), project.getFile()), pomReader);
        List<ModelNode> rawModels = PomHelper.getRawModelTree(rootNode, log);
        return rawModels.stream().filter(node -> Objects.nonNull(node.getModel())).filter(node -> Optional.ofNullable(node.getModel().getBuild()).map(Build::getExtensions).map(list -> !list.isEmpty()).orElse(false)).map(node -> Pair.of((Object)node.getModel().getBuild().getExtensions(), ExtensionUtils.getNodeProperties(node))).flatMap(pair -> ((List)pair.getLeft()).stream().map(e -> Pair.of((Object)e, (Object)((Map)pair.getRight())))).map(pair -> ExtensionBuilder.newBuilder().withGroupId(PomHelper.evaluate(((Extension)pair.getLeft()).getGroupId(), (Map)pair.getRight(), log)).withArtifactId(PomHelper.evaluate(((Extension)pair.getLeft()).getArtifactId(), (Map)pair.getRight(), log)).withVersion(PomHelper.evaluate(((Extension)pair.getLeft()).getVersion(), (Map)pair.getRight(), log)).build());
    }

    private static Map<String, String> getNodeProperties(ModelNode node) {
        HashMap<String, String> properties = new HashMap<String, String>();
        ModelNode p = node;
        while (p != null) {
            p.getModel().getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> properties.putIfAbsent(String.valueOf(key), String.valueOf(value))));
            p = p.getParent().orElse(null);
        }
        return properties;
    }
}

