/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.sonar.ServerMetadata;

public class Bootstraper {
    public static final String REPOSITORY_ID = "sonar";
    private ServerMetadata server;
    private PluginManager pluginManager;
    private ArtifactRepositoryFactory repoFactory;
    private Log log;

    public Bootstraper(ServerMetadata server, ArtifactRepositoryFactory repoFactory, PluginManager pluginManager, Log log) {
        this.server = server;
        this.repoFactory = repoFactory;
        this.pluginManager = pluginManager;
        this.log = log;
    }

    public void start(MavenProject project, MavenSession session) throws IOException, MojoExecutionException {
        if (this.server.needsSonarInternalRepository()) {
            this.configureInternalRepositories(project);
            this.executeMojo(project, session, this.createDeprecatedPlugin(), "internal");
        } else {
            this.executeMojo(project, session, this.createPlugin(), REPOSITORY_ID);
        }
    }

    private void executeMojo(MavenProject project, MavenSession session, Plugin plugin, String goal) throws MojoExecutionException {
        try {
            this.log.info((CharSequence)("Execute: " + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion() + ":" + goal));
            PluginDescriptor pluginDescriptor = this.pluginManager.verifyPlugin(plugin, project, session.getSettings(), session.getLocalRepository());
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
            if (mojoDescriptor == null) {
                throw new MojoExecutionException("Unknown mojo goal: " + goal);
            }
            this.pluginManager.executeMojo(project, new MojoExecution(mojoDescriptor), session);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can not execute Sonar", e);
        }
    }

    private void configureInternalRepositories(MavenProject project) throws IOException {
        ArrayList<ArtifactRepository> pluginRepositories = new ArrayList<ArtifactRepository>();
        ArtifactRepository repository = this.createSonarRepository(this.repoFactory);
        pluginRepositories.add(repository);
        pluginRepositories.addAll(project.getPluginArtifactRepositories());
        project.setPluginArtifactRepositories(pluginRepositories);
        ArrayList<ArtifactRepository> artifactRepositories = new ArrayList<ArtifactRepository>();
        artifactRepositories.add(repository);
        artifactRepositories.addAll(project.getRemoteArtifactRepositories());
        project.setRemoteArtifactRepositories(artifactRepositories);
    }

    private ArtifactRepository createSonarRepository(ArtifactRepositoryFactory repoFactory) {
        return repoFactory.createArtifactRepository(REPOSITORY_ID, this.server.getMavenRepositoryUrl(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(false, "never", "ignore"), new ArtifactRepositoryPolicy(true, "never", "ignore"));
    }

    private Plugin createDeprecatedPlugin() {
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.codehaus.sonar.runtime");
        plugin.setArtifactId("sonar-core-maven-plugin");
        plugin.setVersion(this.server.getKey());
        return plugin;
    }

    private Plugin createPlugin() {
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.codehaus.sonar");
        plugin.setArtifactId("sonar-maven-plugin");
        plugin.setVersion(this.server.getVersion());
        return plugin;
    }
}

