/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.siteskinner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.PublishDate;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Writer;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.mojo.siteskinner.ScmCommandExecutor;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinMojo
extends AbstractMojo {
    private static final String MAVEN_SITE_PLUGIN_KEY = "org.apache.maven.plugins:maven-site-plugin";
    private boolean forceCheckout;
    private boolean mergeBody;
    private boolean siteDeploy;
    private String releasedVersion;
    private File workingDirectory;
    private List<MavenProject> reactorProjects;
    private String inputEncoding;
    private String outputEncoding;
    private MavenProject currentProject;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private RuntimeInformation runtimeInformation;
    private MavenProjectBuilder mavenProjectBuilder;
    private ScmManager scmManager;
    private ArtifactMetadataSource metadataSource;
    private ArtifactFactory factory;
    private ArtifactResolver resolver;
    private SiteTool siteTool;
    private Invoker invoker;

    private String getInputEncoding() {
        return this.inputEncoding == null ? "ISO-8859-1" : this.inputEncoding;
    }

    private String getOutputEncoding() {
        return this.outputEncoding == null ? "UTF-8" : this.outputEncoding;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProject releasedProject;
        Artifact releasedArtifact;
        try {
            releasedArtifact = this.resolveArtifact(this.releasedVersion);
            MavenProject externalProject = this.mavenProjectBuilder.buildFromRepository(releasedArtifact, this.remoteRepositories, this.localRepository);
            this.fetchSources(this.workingDirectory, externalProject);
            releasedProject = this.mavenProjectBuilder.build(new File(this.workingDirectory, "pom.xml"), this.localRepository, null);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        this.verifyVersionCompatibility(releasedProject);
        Xpp3Dom releasedConfig = this.getSitePluginConfiguration(releasedProject);
        String releasedSiteDirectory = releasedConfig == null || releasedConfig.getChild("siteDirectory") == null ? "src/site" : releasedConfig.getChild("siteDirectory").getValue();
        String releasedLocales = releasedConfig == null || releasedConfig.getChild("locales") == null ? null : releasedConfig.getChild("locales").getValue();
        Xpp3Dom currentConfig = this.getSitePluginConfiguration(this.currentProject);
        String currentSiteDirectory = currentConfig == null || currentConfig.getChild("siteDirectory") == null ? "src/site" : currentConfig.getChild("siteDirectory").getValue();
        try {
            DecorationXpp3Writer writer = new DecorationXpp3Writer();
            DecorationXpp3Reader reader = new DecorationXpp3Reader();
            for (Locale locale : this.siteTool.getAvailableLocales(releasedLocales)) {
                long deployDate;
                Xpp3Dom mergedCustom;
                DecorationModel currentModel = this.siteTool.getDecorationModel(this.currentProject, this.reactorProjects, this.localRepository, this.remoteRepositories, currentSiteDirectory, locale, this.getInputEncoding(), this.getOutputEncoding());
                if (currentModel.getSkin() == null) {
                    throw new MojoFailureException("No skin defined in the current 'site.xml', can't apply a new skin on the old site.");
                }
                File releasedSiteXml = this.siteTool.getSiteDescriptorFromBasedir(releasedSiteDirectory, releasedProject.getBasedir(), locale);
                DecorationModel releasedModel = null;
                releasedModel = releasedSiteXml.exists() ? reader.read((InputStream)new FileInputStream(releasedSiteXml), false) : new DecorationModel();
                releasedModel.setBannerLeft(currentModel.getBannerLeft());
                releasedModel.setBannerRight(currentModel.getBannerRight());
                releasedModel.setGoogleAnalyticsAccountId(currentModel.getGoogleAnalyticsAccountId());
                releasedModel.setName(currentModel.getName());
                releasedModel.setPoweredBy(currentModel.getPoweredBy());
                releasedModel.setPublishDate(currentModel.getPublishDate());
                releasedModel.setSkin(currentModel.getSkin());
                if (this.mergeBody && currentModel.getBody() != null) {
                    if (releasedModel.getBody() == null) {
                        releasedModel.setBody(new Body());
                    }
                    releasedModel.getBody().setBreadcrumbs(currentModel.getBody().getBreadcrumbs());
                    releasedModel.getBody().setFooter(currentModel.getBody().getFooter());
                    releasedModel.getBody().setHead(currentModel.getBody().getHead());
                    releasedModel.getBody().setLinks(currentModel.getBody().getLinks());
                }
                if ((mergedCustom = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)currentModel.getCustom()), (Xpp3Dom)((Xpp3Dom)releasedModel.getCustom()))) == null) {
                    mergedCustom = new Xpp3Dom("custom");
                }
                Xpp3Dom publishDateChild = new Xpp3Dom("publishDate");
                long preResolveDate = System.currentTimeMillis();
                try {
                    this.resolver.resolveAlways(releasedArtifact, this.remoteRepositories, this.localRepository);
                }
                catch (ArtifactResolutionException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
                catch (ArtifactNotFoundException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
                if (releasedArtifact.getFile().lastModified() < preResolveDate) {
                    deployDate = releasedArtifact.getFile().lastModified();
                } else {
                    JarFile jarFile = new JarFile(releasedArtifact.getFile());
                    JarEntry entry = jarFile.entries().nextElement();
                    deployDate = entry.getTime();
                }
                Date releaseDate = new Date(deployDate);
                String publishDateFormat = releasedModel.getPublishDate() != null ? releasedModel.getPublishDate().getFormat() : new PublishDate().getFormat();
                publishDateChild.setValue(new SimpleDateFormat(publishDateFormat).format(releaseDate));
                mergedCustom.addChild(publishDateChild);
                releasedModel.setCustom((Object)mergedCustom);
                writer.write((OutputStream)new FileOutputStream(releasedSiteXml), releasedModel);
            }
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Collections.singletonList(this.siteDeploy ? "site-deploy" : "site"));
        request.setPomFile(releasedProject.getFile());
        try {
            InvocationResult invocationResult = this.invoker.execute((InvocationRequest)request);
            if (invocationResult.getExitCode() != 0) {
                throw new MojoExecutionException(invocationResult.getExecutionException().getMessage());
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void verifyVersionCompatibility(MavenProject releasedProject) throws MojoFailureException {
        ArtifactVersion sitePluginVersion = this.getSitePluginVersion(releasedProject);
        ArtifactVersion mavenVersion = this.getMavenVersion();
        if (sitePluginVersion != null) {
            try {
                if (VersionRange.createFromVersionSpec((String)"(,3.0-alpha-1)").containsVersion(sitePluginVersion) && VersionRange.createFromVersionSpec((String)"[3.0,)").containsVersion(mavenVersion)) {
                    throw new MojoFailureException("maven-site-plugin:" + sitePluginVersion + " can only be executed with Maven 2.x");
                }
                if (VersionRange.createFromVersionSpec((String)"[3.0-alpha-1,3.0)").containsVersion(sitePluginVersion) && VersionRange.createFromVersionSpec((String)"(, 3.0)").containsVersion(mavenVersion)) {
                    throw new MojoFailureException("maven-site-plugin:" + sitePluginVersion + " can only be executed with Maven 3.x+");
                }
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoFailureException(e.getMessage());
            }
        }
    }

    private Xpp3Dom getSitePluginConfiguration(MavenProject releasedProject) {
        Plugin sitePlugin = (Plugin)releasedProject.getBuild().getPluginsAsMap().get(MAVEN_SITE_PLUGIN_KEY);
        if (sitePlugin == null) {
            sitePlugin = (Plugin)releasedProject.getBuild().getPluginManagement().getPluginsAsMap().get(MAVEN_SITE_PLUGIN_KEY);
        }
        return (Xpp3Dom)sitePlugin.getConfiguration();
    }

    private ArtifactVersion getSitePluginVersion(MavenProject releasedProject) {
        DefaultArtifactVersion sitePluginVersion = null;
        Plugin sitePlugin = (Plugin)releasedProject.getBuild().getPluginsAsMap().get(MAVEN_SITE_PLUGIN_KEY);
        if (sitePlugin == null) {
            sitePlugin = (Plugin)releasedProject.getBuild().getPluginManagement().getPluginsAsMap().get(MAVEN_SITE_PLUGIN_KEY);
        }
        if (sitePlugin != null && sitePlugin.getVersion() != null) {
            sitePluginVersion = new DefaultArtifactVersion(sitePlugin.getVersion());
        }
        return sitePluginVersion;
    }

    private ArtifactVersion getMavenVersion() {
        return this.runtimeInformation.getApplicationVersion();
    }

    private String getConnection(MavenProject mavenProject) throws MojoFailureException {
        if (mavenProject.getScm() == null) {
            throw new MojoFailureException("SCM Connection is not set in your pom.xml.");
        }
        String connection = mavenProject.getScm().getConnection();
        if (connection != null && connection.length() > 0) {
            return connection;
        }
        connection = mavenProject.getScm().getDeveloperConnection();
        if (StringUtils.isEmpty((String)connection)) {
            throw new MojoFailureException("SCM Connection is not set in your pom.xml.");
        }
        return connection;
    }

    private Artifact resolveArtifact(String versionSpec) throws MojoFailureException, MojoExecutionException {
        Artifact previousArtifact;
        VersionRange range;
        try {
            range = VersionRange.createFromVersionSpec((String)versionSpec);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("Invalid comparison version: " + e.getMessage());
        }
        try {
            previousArtifact = this.factory.createDependencyArtifact(this.currentProject.getGroupId(), this.currentProject.getArtifactId(), range, this.currentProject.getPackaging(), null, "compile");
            if (!previousArtifact.getVersionRange().isSelectedVersionKnown(previousArtifact)) {
                this.getLog().debug((CharSequence)("Searching for versions in range: " + previousArtifact.getVersionRange()));
                List availableVersions = this.metadataSource.retrieveAvailableVersions(previousArtifact, this.localRepository, this.currentProject.getRemoteArtifactRepositories());
                this.filterSnapshots(availableVersions);
                ArtifactVersion version = range.matchVersion(availableVersions);
                if (version != null) {
                    previousArtifact.selectVersion(version.toString());
                }
            }
        }
        catch (OverConstrainedVersionException e1) {
            throw new MojoFailureException("Invalid comparison version: " + e1.getMessage());
        }
        catch (ArtifactMetadataRetrievalException e11) {
            throw new MojoExecutionException("Error determining previous version: " + e11.getMessage(), (Exception)((Object)e11));
        }
        if (previousArtifact.getVersion() == null) {
            this.getLog().info((CharSequence)"Unable to find a previous version of the project in the repository");
        } else {
            this.getLog().debug((CharSequence)("Previous version: " + previousArtifact.getVersion()));
        }
        return previousArtifact;
    }

    private void filterSnapshots(List<ArtifactVersion> versions) {
        Iterator<ArtifactVersion> versionIterator = versions.iterator();
        while (versionIterator.hasNext()) {
            if (!"SNAPSHOT".equals(versionIterator.next().getQualifier())) continue;
            versionIterator.remove();
        }
    }

    private void fetchSources(File checkoutDir, MavenProject mavenProject) throws MojoExecutionException {
        try {
            if (this.forceCheckout && checkoutDir.exists()) {
                FileUtils.deleteDirectory((File)checkoutDir);
            }
            if (checkoutDir.mkdirs()) {
                this.getLog().info((CharSequence)("Performing checkout to " + checkoutDir));
                new ScmCommandExecutor(this.scmManager, this.getConnection(mavenProject), this.getLog()).checkout(checkoutDir.getPath());
            } else {
                this.getLog().info((CharSequence)("Performing update to " + checkoutDir));
                new ScmCommandExecutor(this.scmManager, this.getConnection(mavenProject), this.getLog()).update(checkoutDir.getPath());
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("checkout failed.", ex);
        }
    }
}

