/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.maven;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.mojo.mrm.api.maven.Artifact;
import org.codehaus.mojo.mrm.api.maven.ArtifactNotFoundException;
import org.codehaus.mojo.mrm.api.maven.BaseArtifactStore;
import org.codehaus.mojo.mrm.api.maven.MetadataNotFoundException;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MemoryArtifactStore
extends BaseArtifactStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map contents = new HashMap();

    public synchronized Set getGroupIds(String parentGroupId) {
        TreeSet<String> result = new TreeSet<String>();
        if (StringUtils.isEmpty((String)parentGroupId)) {
            for (String groupId : this.contents.keySet()) {
                int index = groupId.indexOf(46);
                result.add(index == -1 ? groupId : groupId.substring(0, index));
            }
        } else {
            String prefix = parentGroupId + '.';
            int start = prefix.length();
            for (String groupId : this.contents.keySet()) {
                if (!groupId.startsWith(prefix)) continue;
                int index = groupId.indexOf(46, start);
                result.add(index == -1 ? groupId.substring(start) : groupId.substring(start, index));
            }
        }
        return result;
    }

    public synchronized Set getArtifactIds(String groupId) {
        Map artifactMap = (Map)this.contents.get(groupId);
        return new TreeSet(artifactMap == null ? Collections.EMPTY_SET : artifactMap.keySet());
    }

    public synchronized Set getVersions(String groupId, String artifactId) {
        Map artifactMap = (Map)this.contents.get(groupId);
        Map versionMap = artifactMap == null ? null : artifactMap.get(artifactId);
        return new TreeSet(versionMap == null ? Collections.EMPTY_SET : versionMap.keySet());
    }

    public synchronized Set getArtifacts(String groupId, String artifactId, String version) {
        Map artifactMap = (Map)this.contents.get(groupId);
        Map versionMap = artifactMap == null ? null : artifactMap.get(artifactId);
        Map filesMap = versionMap == null ? null : versionMap.get(version);
        return new HashSet(filesMap == null ? Collections.EMPTY_SET : filesMap.keySet());
    }

    public synchronized long getLastModified(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Map artifactMap = (Map)this.contents.get(artifact.getGroupId());
        Map versionMap = artifactMap == null ? null : artifactMap.get(artifact.getArtifactId());
        Map filesMap = versionMap == null ? null : versionMap.get(artifact.getVersion());
        Content content = filesMap == null ? null : filesMap.get(artifact);
        if (content == null) {
            if (artifact.isSnapshot() && artifact.getTimestamp() == null && filesMap != null) {
                Artifact best = null;
                for (Map.Entry entry : filesMap.entrySet()) {
                    Artifact a = (Artifact)entry.getKey();
                    if (!artifact.equalSnapshots(a) || best != null && best.compareTo(a) >= 0) continue;
                    best = a;
                    content = (Content)entry.getValue();
                }
                if (content == null) {
                    throw new ArtifactNotFoundException(artifact);
                }
            } else {
                throw new ArtifactNotFoundException(artifact);
            }
        }
        return content.getLastModified();
    }

    public synchronized long getSize(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Map artifactMap = (Map)this.contents.get(artifact.getGroupId());
        Map versionMap = artifactMap == null ? null : artifactMap.get(artifact.getArtifactId());
        Map filesMap = versionMap == null ? null : versionMap.get(artifact.getVersion());
        Content content = filesMap == null ? null : filesMap.get(artifact);
        if (content == null) {
            if (artifact.isSnapshot() && artifact.getTimestamp() == null && filesMap != null) {
                Artifact best = null;
                for (Map.Entry entry : filesMap.entrySet()) {
                    Artifact a = (Artifact)entry.getKey();
                    if (!artifact.equalSnapshots(a) || best != null && best.compareTo(a) >= 0) continue;
                    best = a;
                    content = (Content)entry.getValue();
                }
                if (content == null) {
                    throw new ArtifactNotFoundException(artifact);
                }
            } else {
                throw new ArtifactNotFoundException(artifact);
            }
        }
        return content.getBytes().length;
    }

    public synchronized InputStream get(Artifact artifact) throws IOException, ArtifactNotFoundException {
        Map artifactMap = (Map)this.contents.get(artifact.getGroupId());
        Map versionMap = artifactMap == null ? null : artifactMap.get(artifact.getArtifactId());
        Map filesMap = versionMap == null ? null : versionMap.get(artifact.getVersion());
        Content content = filesMap == null ? null : filesMap.get(artifact);
        if (content == null) {
            if (artifact.isSnapshot() && artifact.getTimestamp() == null && filesMap != null) {
                Artifact best = null;
                for (Map.Entry entry : filesMap.entrySet()) {
                    Artifact a = (Artifact)entry.getKey();
                    if (!artifact.equalSnapshots(a) || best != null && best.compareTo(a) >= 0) continue;
                    best = a;
                    content = (Content)entry.getValue();
                }
                if (content == null) {
                    throw new ArtifactNotFoundException(artifact);
                }
            } else {
                throw new ArtifactNotFoundException(artifact);
            }
        }
        return new ByteArrayInputStream(content.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void set(Artifact artifact, InputStream content) throws IOException {
        HashMap<Artifact, Content> filesMap;
        HashMap<String, HashMap<Artifact, Content>> versionMap;
        HashMap artifactMap = (HashMap)this.contents.get(artifact.getGroupId());
        if (artifactMap == null) {
            artifactMap = new HashMap();
            this.contents.put(artifact.getGroupId(), artifactMap);
        }
        if ((versionMap = (HashMap<String, HashMap<Artifact, Content>>)artifactMap.get(artifact.getArtifactId())) == null) {
            versionMap = new HashMap<String, HashMap<Artifact, Content>>();
            artifactMap.put(artifact.getArtifactId(), versionMap);
        }
        if ((filesMap = (HashMap<Artifact, Content>)versionMap.get(artifact.getVersion())) == null) {
            filesMap = new HashMap<Artifact, Content>();
            versionMap.put(artifact.getVersion(), filesMap);
        }
        try {
            filesMap.put(artifact, new Content(IOUtils.toByteArray((InputStream)content)));
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Metadata getMetadata(String path) throws IOException, MetadataNotFoundException {
        Map artifactMap;
        Map versionMap;
        Map filesMap;
        String version;
        Set artifactVersions;
        String artifactId;
        int index;
        Object versions;
        Metadata metadata = new Metadata();
        boolean foundMetadata = false;
        String groupId = (path = StringUtils.stripEnd((String)StringUtils.stripStart((String)path, (String)"/"), (String)"/")).replace('/', '.');
        Set pluginArtifactIds = this.getArtifactIds(groupId);
        if (pluginArtifactIds != null) {
            ArrayList<Plugin> plugins = new ArrayList<Plugin>();
            block13: for (String artifactId2 : pluginArtifactIds) {
                Set pluginVersions = this.getVersions(groupId, artifactId2);
                if (pluginVersions == null || pluginVersions.isEmpty()) continue;
                versions = pluginVersions.toArray(new String[pluginVersions.size()]);
                Arrays.sort(versions, new VersionComparator());
                MavenXpp3Reader reader = new MavenXpp3Reader();
                for (int j = ((String[])versions).length - 1; j >= 0; --j) {
                    Model model;
                    InputStream inputStream;
                    block32: {
                        inputStream = null;
                        inputStream = this.get(new Artifact(groupId, artifactId2, (String)versions[j], "pom"));
                        model = reader.read((Reader)new XmlStreamReader(inputStream));
                        if (model != null && "maven-plugin".equals(model.getPackaging())) break block32;
                        IOUtils.closeQuietly((InputStream)inputStream);
                        continue;
                    }
                    try {
                        Plugin plugin = new Plugin();
                        plugin.setArtifactId(artifactId2);
                        plugin.setName(model.getName());
                        boolean havePrefix = false;
                        Build build = model.getBuild();
                        if (build != null && build.getPlugins() != null) {
                            havePrefix = this.setPluginGoalPrefixFromConfiguration(plugin, build.getPlugins());
                        }
                        if (!havePrefix && build != null && build.getPluginManagement() != null && build.getPluginManagement().getPlugins() != null) {
                            havePrefix = this.setPluginGoalPrefixFromConfiguration(plugin, build.getPluginManagement().getPlugins());
                        }
                        if (!havePrefix && artifactId2.startsWith("maven-") && artifactId2.endsWith("-plugin")) {
                            plugin.setPrefix(StringUtils.removeStart((String)StringUtils.removeEnd((String)artifactId2, (String)"-plugin"), (String)"maven-"));
                            havePrefix = true;
                        }
                        if (!havePrefix && artifactId2.endsWith("-maven-plugin")) {
                            plugin.setPrefix(StringUtils.removeEnd((String)artifactId2, (String)"-maven-plugin"));
                            havePrefix = true;
                        }
                        if (!havePrefix) {
                            plugin.setPrefix(artifactId2);
                        }
                        plugins.add(plugin);
                        foundMetadata = true;
                    }
                    catch (ArtifactNotFoundException e) {
                        IOUtils.closeQuietly(inputStream);
                        continue;
                    }
                    catch (XmlPullParserException e) {
                        IOUtils.closeQuietly(inputStream);
                        continue;
                        {
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(inputStream);
                                throw throwable;
                            }
                        }
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                    continue block13;
                }
            }
            if (!plugins.isEmpty()) {
                metadata.setPlugins(plugins);
            }
        }
        groupId = ((index = path.lastIndexOf(47)) == -1 ? groupId : groupId.substring(0, index)).replace('/', '.');
        String string = artifactId = index == -1 ? null : path.substring(index + 1);
        if (artifactId != null && (artifactVersions = this.getVersions(groupId, artifactId)) != null && !artifactVersions.isEmpty()) {
            metadata.setGroupId(groupId);
            metadata.setArtifactId(artifactId);
            Versioning versioning = new Versioning();
            versions = new ArrayList(artifactVersions);
            Collections.sort(versions, new VersionComparator());
            long lastUpdated = 0L;
            Iterator i = versions.iterator();
            while (i.hasNext()) {
                String version2 = (String)i.next();
                try {
                    long lastModified = this.getLastModified(new Artifact(groupId, artifactId, version2, "pom"));
                    versioning.addVersion(version2);
                    if (lastModified < lastUpdated) continue;
                    lastUpdated = lastModified;
                    versioning.setLastUpdatedTimestamp(new Date(lastModified));
                    versioning.setLatest(version2);
                    if (version2.endsWith("-SNAPSHOT")) continue;
                    versioning.setRelease(version2);
                }
                catch (ArtifactNotFoundException e) {}
            }
            metadata.setVersioning(versioning);
            foundMetadata = true;
        }
        int index2 = index == -1 ? -1 : path.lastIndexOf(47, index - 1);
        groupId = index2 == -1 ? groupId : groupId.substring(0, index2).replace('/', '.');
        artifactId = index2 == -1 ? artifactId : path.substring(index2 + 1, index);
        String string2 = version = index2 == -1 ? null : path.substring(index + 1);
        if (version != null && version.endsWith("-SNAPSHOT") && (filesMap = (Map)((versionMap = (Map)((artifactMap = (Map)this.contents.get(groupId)) == null ? null : artifactMap.get(artifactId))) == null ? null : versionMap.get(version))) != null) {
            ArrayList snapshotVersions = new ArrayList();
            int maxBuildNumber = 0;
            long lastUpdated = 0L;
            String timestamp = null;
            boolean found = false;
            for (Map.Entry entry : filesMap.entrySet()) {
                Artifact artifact = (Artifact)entry.getKey();
                Content content = (Content)entry.getValue();
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss");
                fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
                String lastUpdatedTime = fmt.format(new Date(content.getLastModified()));
                try {
                    Maven3.addSnapshotVersion(snapshotVersions, artifact, lastUpdatedTime);
                }
                catch (LinkageError e) {
                    // empty catch block
                }
                if (!"pom".equals(artifact.getType())) continue;
                if (artifact.getBuildNumber() != null && maxBuildNumber < artifact.getBuildNumber()) {
                    maxBuildNumber = artifact.getBuildNumber();
                    timestamp = artifact.getTimestampString();
                } else {
                    maxBuildNumber = Math.max(1, maxBuildNumber);
                }
                lastUpdated = Math.max(lastUpdated, content.getLastModified());
                found = true;
            }
            if (!snapshotVersions.isEmpty() || found) {
                Versioning versioning = metadata.getVersioning();
                if (versioning == null) {
                    versioning = new Versioning();
                }
                metadata.setGroupId(groupId);
                metadata.setArtifactId(artifactId);
                metadata.setVersion(version);
                try {
                    Maven3.addSnapshotVersions(versioning, snapshotVersions);
                }
                catch (LinkageError e) {
                    // empty catch block
                }
                if (maxBuildNumber > 0) {
                    Snapshot snapshot = new Snapshot();
                    snapshot.setBuildNumber(maxBuildNumber);
                    snapshot.setTimestamp(timestamp);
                    versioning.setSnapshot(snapshot);
                }
                versioning.setLastUpdatedTimestamp(new Date(lastUpdated));
                metadata.setVersioning(versioning);
                foundMetadata = true;
            }
        }
        if (!foundMetadata) {
            throw new MetadataNotFoundException(path);
        }
        return metadata;
    }

    public synchronized long getMetadataLastModified(String path) throws IOException, MetadataNotFoundException {
        Map versionMap;
        Map filesMap;
        String version;
        Map versionMap2;
        String artifactId;
        int index;
        boolean haveResult = false;
        long result = 0L;
        String groupId = (path = StringUtils.stripEnd((String)StringUtils.stripStart((String)path, (String)"/"), (String)"/")).replace('/', '.');
        Map artifactMap = (Map)this.contents.get(groupId);
        if (artifactMap != null) {
            for (Map versionMap3 : artifactMap.values()) {
                for (Map filesMap2 : versionMap3.values()) {
                    for (Content content : filesMap2.values()) {
                        haveResult = true;
                        result = Math.max(result, content.getLastModified());
                    }
                }
            }
        }
        groupId = (index = path.lastIndexOf(47)) == -1 ? groupId : groupId.substring(0, index).replace('/', '.');
        String string = artifactId = index == -1 ? null : path.substring(index + 1);
        if (artifactId != null && (versionMap2 = (Map)((artifactMap = (Map)this.contents.get(groupId)) == null ? null : artifactMap.get(artifactId))) != null) {
            for (Map filesMap3 : versionMap2.values()) {
                for (Content content : filesMap3.values()) {
                    haveResult = true;
                    result = Math.max(result, content.getLastModified());
                }
            }
        }
        int index2 = index == -1 ? -1 : path.lastIndexOf(47, index - 1);
        groupId = index2 == -1 ? groupId : groupId.substring(0, index2).replace('/', '.');
        artifactId = index2 == -1 ? artifactId : path.substring(index2 + 1, index);
        String string2 = version = index2 == -1 ? null : path.substring(index + 1);
        if (version != null && version.endsWith("-SNAPSHOT") && (filesMap = (Map)((versionMap = (Map)((artifactMap = (Map)this.contents.get(groupId)) == null ? null : artifactMap.get(artifactId))) == null ? null : versionMap.get(version))) != null) {
            for (Content content : filesMap.values()) {
                haveResult = true;
                result = Math.max(result, content.getLastModified());
            }
        }
        if (haveResult) {
            return result;
        }
        throw new MetadataNotFoundException(path);
    }

    private boolean setPluginGoalPrefixFromConfiguration(Plugin plugin, List pluginConfigs) {
        for (org.apache.maven.model.Plugin def : pluginConfigs) {
            Xpp3Dom goalPrefix;
            if (def.getGroupId() != null && !StringUtils.equals((String)"org.apache.maven.plugins", (String)def.getGroupId()) || !StringUtils.equals((String)"maven-plugin-plugin", (String)def.getArtifactId())) continue;
            Xpp3Dom configuration = (Xpp3Dom)def.getConfiguration();
            if (configuration == null || (goalPrefix = configuration.getChild("goalPrefix")) == null) break;
            plugin.setPrefix(goalPrefix.getValue());
            return true;
        }
        return false;
    }

    private static class Maven3 {
        private Maven3() {
        }

        private static void addSnapshotVersion(List snapshotVersions, Artifact artifact, String lastUpdatedTime) {
            try {
                SnapshotVersion snapshotVersion = new SnapshotVersion();
                snapshotVersion.setExtension(artifact.getType());
                snapshotVersion.setClassifier(artifact.getClassifier() == null ? "" : artifact.getClassifier());
                snapshotVersion.setVersion(artifact.getTimestampVersion());
                snapshotVersion.setUpdated(lastUpdatedTime);
                snapshotVersions.add(snapshotVersion);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }

        private static void addSnapshotVersions(Versioning versioning, List snapshotVersions) {
            try {
                for (SnapshotVersion snapshotVersion : snapshotVersions) {
                    versioning.addSnapshotVersion(snapshotVersion);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private static class Content
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long lastModified = System.currentTimeMillis();
        private final byte[] bytes;

        private Content(byte[] bytes) {
            this.bytes = bytes;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }

    private static class VersionComparator
    implements Comparator {
        private VersionComparator() {
        }

        public int compare(Object o1, Object o2) {
            DefaultArtifactVersion v1 = new DefaultArtifactVersion((String)o1);
            DefaultArtifactVersion v2 = new DefaultArtifactVersion((String)o2);
            return v1.compareTo((Object)v2);
        }
    }
}

