/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ruby;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.component.jruby.JRubyRuntimeInvoker;
import org.codehaus.plexus.util.StringOutputStream;

public class RunScriptMojo
extends AbstractMojo {
    private File script;
    private String ruby;
    private String[] libraryPaths;
    private String[] requires;
    private boolean assumeLoop;
    private boolean assumePrintLoop;
    private boolean autoSplit;
    private boolean processLineEnds;
    private int warning;
    private boolean debug;
    private File currentDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        JRubyRuntimeInvoker invoker = new JRubyRuntimeInvoker(null);
        if (this.script != null) {
            try {
                FileInputStream scriptStream = new FileInputStream(this.script);
                invoker.setReader((Reader)new InputStreamReader(scriptStream));
            }
            catch (FileNotFoundException e) {
                throw new MojoFailureException(e.getMessage());
            }
        } else if (this.ruby != null) {
            invoker.setReader((Reader)new StringReader(this.ruby));
        } else {
            throw new MojoFailureException("Cannot execute [rubyscript:run] without configuring either 'script' or 'ruby'");
        }
        invoker.setCurrentDirectory(this.currentDirectory.getAbsolutePath());
        invoker.setAssumePrintLoop(this.assumePrintLoop);
        invoker.setAssumeLoop(this.assumeLoop);
        invoker.setAutoSplit(this.autoSplit);
        invoker.setProcessLineEnds(this.processLineEnds);
        invoker.setWarning(this.warning);
        invoker.setDebug(this.debug);
        invoker.setLibraryPaths(this.libraryPaths);
        invoker.setRequires(this.requires);
        try {
            StringOutputStream stdout = new StringOutputStream();
            StringOutputStream stderr = new StringOutputStream();
            invoker.invoke((OutputStream)stdout, (OutputStream)stderr);
            this.logOutput(stdout.toString(), false);
            this.logOutput(stderr.toString(), true);
        }
        catch (Throwable e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    private void logOutput(String output, boolean error) {
        if (output != null && output.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(output, "\n");
            while (tokens.hasMoreTokens()) {
                if (error) {
                    this.getLog().error((CharSequence)tokens.nextToken());
                    continue;
                }
                this.getLog().info((CharSequence)tokens.nextToken());
            }
        }
    }
}

