/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.deployall;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.mojo.deployall.AbstractDeployMojo;

public class DeployExistingSourcesMojo
extends AbstractDeployMojo {
    private MavenProject project;
    private File sourceFile;
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File sshFile;
        ArtifactRepository deploymentRepository = this.project.getDistributionManagementArtifactRepository();
        if (this.sourceFile == null || !this.sourceFile.exists()) {
            this.getLog().info((CharSequence)("Source-archive doesn't exist. Skipping project: " + this.project.getId()));
            return;
        }
        if (deploymentRepository == null) {
            String msg = "Deployment failed: repository element was not specified in the pom inside distributionManagement element. Skipping project: " + this.project.getId();
            this.getLog().info((CharSequence)msg);
            return;
        }
        String protocol = deploymentRepository.getProtocol();
        if (protocol.equals("scp") && !(sshFile = new File(System.getProperty("user.home"), ".ssh")).exists()) {
            sshFile.mkdirs();
        }
        String type = null;
        String sourceFileName = this.sourceFile.getName();
        if (sourceFileName.endsWith(".tgz")) {
            type = "tgz";
        } else if (sourceFileName.endsWith(".tar.gz")) {
            type = "tar.gz";
        } else if (sourceFileName.endsWith(".tar.bz2")) {
            type = "tar.bz2";
        } else if (sourceFileName.endsWith(".tar.Z")) {
            type = "tar.Z";
        } else if (sourceFileName.endsWith(".zip")) {
            type = "zip";
        } else if (sourceFileName.endsWith(".bin")) {
            type = "bin";
        } else {
            int dot = this.sourceFile.getName().indexOf(46);
            type = this.sourceFile.getName().substring(dot + 1);
        }
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), type, "sources");
        artifact.setFile(this.sourceFile);
        File pomFile = this.project.getFile();
        boolean isPomArtifact = "pom".equals(this.project.getPackaging());
        if (!isPomArtifact) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
        try {
            if (isPomArtifact) {
                this.getDeployer().deploy(pomFile, artifact, deploymentRepository, this.getLocalRepository());
            } else {
                this.getDeployer().deploy(this.sourceFile, artifact, deploymentRepository, this.getLocalRepository());
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

