/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.mojo.chronos.common.model.HistoricSample;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HistoricSamples {
    private Set groupNames = new LinkedHashSet();
    private List samples = new ArrayList();

    public HistoricSamples(Iterable<HistoricSample> samples) {
        for (HistoricSample sample : samples) {
            this.addHistoricSample(sample);
        }
    }

    public void addHistoricSample(HistoricSample sample) {
        this.samples.add(sample);
        this.groupNames.addAll(sample.getGroupNames());
    }

    public String[] getGroupNames() {
        return this.groupNames.toArray(new String[this.groupNames.size()]);
    }

    public TimeSeries getAverageTime(String name) {
        return this.visitAll(name, new HistoricSampleFullExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getResponsetimeAverage();
            }
        });
    }

    public TimeSeries getAverageTime(String name, final String groupName) {
        return this.visitAll(name, new HistoricSampleExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getResponsetimeAverage(groupName);
            }

            public boolean accept(HistoricSample sample) {
                return sample.getGroupNames().contains(groupName);
            }
        });
    }

    public TimeSeries getpercentile95(String name) {
        return this.visitAll(name, new HistoricSampleFullExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getResponsetime95Percentile();
            }
        });
    }

    public TimeSeries getPercentile95(String name, final String groupName) {
        return this.visitAll(name, new HistoricSampleExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getResponsetimePercentiles(groupName);
            }

            public boolean accept(HistoricSample sample) {
                return sample.getGroupNames().contains(groupName);
            }
        });
    }

    public TimeSeries getThroughput(String name) {
        return this.visitAll(name, new HistoricSampleFullExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getMaxAverageThroughput();
            }
        });
    }

    public TimeSeries getGcRatio(String name) {
        return this.visitAll(name, new HistoricSampleFullExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getGcRatio();
            }
        });
    }

    public TimeSeries getKbCollectedPrSecond(String name) {
        return this.visitAll(name, new HistoricSampleFullExtractor(){

            public double extract(HistoricSample sample) {
                return sample.getCollectedPrSecond();
            }
        });
    }

    private TimeSeries visitAll(String name, HistoricSampleExtractor visitor) {
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        for (HistoricSample sample : this.samples) {
            if (!visitor.accept(sample)) continue;
            Millisecond timestamp = new Millisecond(new Date(sample.getTimestamp()));
            double value = visitor.extract(sample);
            series.addOrUpdate((RegularTimePeriod)timestamp, value);
        }
        return series;
    }

    private abstract class HistoricSampleFullExtractor
    implements HistoricSampleExtractor {
        private HistoricSampleFullExtractor() {
        }

        public abstract double extract(HistoricSample var1);

        public final boolean accept(HistoricSample sample) {
            return true;
        }
    }

    static interface HistoricSampleExtractor {
        public double extract(HistoricSample var1);

        public boolean accept(HistoricSample var1);
    }
}

