/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.chart;

import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSamples;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.codehaus.mojo.chronos.report.chart.ChartUtil;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.SeriesRenderingOrder;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public abstract class ResponseChartGenerator {
    protected final JFreeChart createResponseChart(ResponsetimeSamples samples, ResourceBundle bundle, ReportConfig config) {
        String text;
        TimeSeriesCollection dataset = this.createResponseDataset(samples, bundle, config);
        String title = bundle.getString("chronos.label.responsetimes");
        String timeAxisLabel = bundle.getString("chronos.label.responsetimes.time");
        String valueAxisLabel = bundle.getString("chronos.label.responsetimes.responsetime");
        JFreeChart chart = ChartUtil.createTimeSeriesChart((XYDataset)dataset, title, timeAxisLabel, valueAxisLabel);
        ChartUtil.setupXYPlot(chart, new SimpleDateFormat("HH:mm:ss"));
        chart.getXYPlot().setSeriesRenderingOrder(SeriesRenderingOrder.FORWARD);
        if (config.isShowpercentile95()) {
            text = bundle.getString("chronos.label.percentile95.arrow");
            ChartUtil.addRangeMarker(chart.getXYPlot(), text, samples.getPercentile95());
        }
        if (config.isShowpercentile99()) {
            text = bundle.getString("chronos.label.percentile99.arrow");
            ChartUtil.addRangeMarker(chart.getXYPlot(), text, samples.getPercentile99());
        }
        if (config.isShowaverage()) {
            text = bundle.getString("chronos.label.average.arrow");
            ChartUtil.addRangeMarker(chart.getXYPlot(), text, samples.getAverage());
        }
        return chart;
    }

    private TimeSeriesCollection createResponseDataset(ResponsetimeSamples samples, ResourceBundle bundle, ReportConfig config) {
        TimeSeries series = samples.createResponseTimeSeries();
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        String averageLabel = bundle.getString("chronos.label.average");
        TimeSeries averageseries = MovingAverage.createMovingAverage((TimeSeries)series, (String)averageLabel, (int)config.getAverageduration(), (int)0);
        dataset.addSeries(averageseries);
        return dataset;
    }
}

