/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.vsslib;

import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.plugin.logging.Log;

public class VssConnection {
    private static final Log LOG = ChangeLog.getLog();
    private String vssDir;
    private String vssUserInf;
    private String vssProject;

    public VssConnection(String connection) {
        if (!connection.startsWith("scm:vss")) {
            throw new IllegalArgumentException("repositoy connection string does not specify 'vss' as the scm");
        }
        try {
            String[] splitedConnection = connection.split(":");
            this.vssDir = splitedConnection[2];
            if (!splitedConnection[3].equals("")) {
                this.vssUserInf = splitedConnection[3];
            }
            this.vssProject = splitedConnection[4];
        }
        catch (Exception e) {
            String message = "Unable to parse VSS connection string :" + connection;
            LOG.error((CharSequence)message, (Throwable)e);
            throw new IllegalArgumentException(message);
        }
    }

    public String getVssDir() {
        return this.vssDir;
    }

    public String getVssProject() {
        return this.vssProject;
    }

    public String getVssUserInf() {
        return this.vssUserInf;
    }
}

