/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChangeLogHandler
extends DefaultHandler {
    private Collection changeSets;
    private SimpleDateFormat sdf;
    private String bufData;
    private ChangeLogFile bufFile;
    private ChangeLogEntry bufEntry;
    private LinkedList bufEntries;
    private ChangeLogSet bufSet;

    public ChangeLogHandler(Collection changeSets, String dateFormat) {
        this.changeSets = changeSets;
        this.sdf = new SimpleDateFormat(dateFormat);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bufData = this.bufData + new String(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("changeset".equals(qName)) {
            this.changeSets.add(this.bufSet);
        }
        if ("changelog-entry".equals(qName)) {
            this.bufEntries.add(this.bufEntry);
        }
        if ("file".equals(qName)) {
            this.bufEntry.addFile(this.bufFile);
        } else if ("date".equals(qName)) {
            try {
                this.bufEntry.setDate(this.sdf.parse(this.bufData));
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        } else if ("author".equals(qName)) {
            this.bufEntry.setAuthor(this.bufData);
        } else if ("msg".equals(qName)) {
            this.bufEntry.setComment(this.bufData);
        }
        if ("revision".equals(qName)) {
            this.bufFile.setRevision(this.bufData);
        } else if ("name".equals(qName)) {
            this.bufFile.setName(this.bufData);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.bufData = "";
        if ("file".equals(qName)) {
            this.bufFile = new ChangeLogFile("");
        } else if ("changelog-entry".equals(qName)) {
            this.bufEntry = new ChangeLogEntry();
        } else if ("changeset".equals(qName)) {
            this.bufEntries = new LinkedList();
            String start = attributes.getValue("start");
            String end = attributes.getValue("end");
            this.bufSet = new ChangeLogSet(this.bufEntries, start, end);
        }
    }
}

