/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogGenerator;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.util.AsyncStreamReader;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Commandline;

public abstract class AbstractChangeLogGenerator
implements ChangeLogGenerator,
ExecuteStreamHandler {
    protected File base;
    protected ChangeLog changeLogExecutor;
    protected ChangeLogParser clParser;
    private String connection;
    protected String type;
    protected String dateRange;
    protected String tag;
    protected String logStart = "";
    protected String logEnd = "";
    protected Collection entries;
    protected AsyncStreamReader errorReader;
    protected InputStream in;
    protected String commentFormat;
    private static Log LOG = ChangeLog.getLog();

    public void init(ChangeLog changeLog) {
        this.changeLogExecutor = changeLog;
        this.base = this.changeLogExecutor.getBasedir();
        this.type = this.changeLogExecutor.getType();
        if (this.type.equalsIgnoreCase("tag")) {
            this.tag = this.getScmTagArgument(this.changeLogExecutor.getMarkerStart(), this.changeLogExecutor.getMarkerEnd());
            this.logStart = this.changeLogExecutor.getMarkerStart();
            this.logEnd = this.changeLogExecutor.getMarkerEnd() == null ? "" : this.changeLogExecutor.getMarkerEnd();
        } else if (this.type.equalsIgnoreCase("date")) {
            this.setDateRangeFromAbsoluteDate(this.changeLogExecutor.getMarkerStart(), this.changeLogExecutor.getMarkerEnd());
        } else if (this.changeLogExecutor.getRange() != null && this.changeLogExecutor.getRange().length() != 0) {
            this.setDateRange(this.changeLogExecutor.getMarkerStart(), this.changeLogExecutor.getMarkerEnd());
        }
        this.setConnection(this.changeLogExecutor.getRepositoryConnection());
        this.setCommentFormat(this.changeLogExecutor.getCommentFormat());
    }

    protected void setDateRange(String numDaysStartString, String numDaysEndString) {
        int daysStart = Integer.parseInt(numDaysStartString);
        int daysEnd = numDaysEndString == null ? -1 : Integer.parseInt(numDaysEndString);
        Date before = new Date(System.currentTimeMillis() - (long)daysStart * 24L * 60L * 60L * 1000L);
        Date to = new Date(System.currentTimeMillis() - (long)daysEnd * 24L * 60L * 60L * 1000L);
        this.dateRange = this.getScmDateArgument(before, to);
        this.setLogStart(before);
        this.setLogEnd(to);
    }

    protected void setDateRangeFromAbsoluteDate(String startDate, String endDate) {
        Date to;
        Date before;
        String dateFormat = this.changeLogExecutor.getDateFormat();
        SimpleDateFormat format = dateFormat == null ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat(dateFormat);
        try {
            before = format.parse(startDate);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Unable to parse start date " + startDate + ": " + ex.getLocalizedMessage());
        }
        try {
            to = endDate != null ? format.parse(endDate) : new Date(System.currentTimeMillis() + 86400000L);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Unable to parse end date " + endDate + ": " + ex.getLocalizedMessage());
        }
        this.dateRange = this.getScmDateArgument(before, to);
        this.setLogStart(before);
        this.setLogEnd(to);
    }

    protected void setLogStart(Date start) {
        String dateFormat = this.changeLogExecutor.getDateFormat();
        SimpleDateFormat format = dateFormat == null ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat(dateFormat);
        this.logStart = format.format(start);
    }

    protected void setLogEnd(Date end) {
        String dateFormat = this.changeLogExecutor.getDateFormat();
        SimpleDateFormat format = dateFormat == null ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat(dateFormat);
        this.logEnd = format.format(end);
    }

    public Collection getEntries(ChangeLogParser parser) throws IOException {
        if (parser == null) {
            throw new NullPointerException("parser cannot be null");
        }
        if (this.base == null) {
            throw new NullPointerException("basedir must be set");
        }
        if (!this.base.exists()) {
            throw new FileNotFoundException("Cannot find base dir " + this.base.getAbsolutePath());
        }
        this.clParser = parser;
        try {
            Execute exe = new Execute((ExecuteStreamHandler)this);
            exe.setCommandline(this.getScmLogCommand().getCommandline());
            exe.setWorkingDirectory(this.base);
            AbstractChangeLogGenerator.logExecute(exe, this.base);
            exe.execute();
            String errors = this.errorReader.toString().trim();
            if (errors.length() > 0) {
                LOG.error((CharSequence)errors);
            }
        }
        catch (IOException ioe) {
            this.handleParserException(ioe);
        }
        return this.entries;
    }

    protected void handleParserException(IOException ioe) throws IOException {
        throw ioe;
    }

    public String getLogStart() {
        return this.logStart;
    }

    public String getLogEnd() {
        return this.logEnd;
    }

    public void cleanup() {
    }

    protected abstract Commandline getScmLogCommand();

    protected abstract String getScmDateArgument(Date var1, Date var2);

    protected abstract String getScmTagArgument(String var1, String var2);

    public void stop() {
    }

    public void setProcessInputStream(OutputStream os) {
    }

    public void setProcessErrorStream(InputStream is) {
        this.errorReader = new AsyncStreamReader(is);
    }

    public void setProcessOutputStream(InputStream is) {
        this.in = is;
    }

    public void start() throws IOException {
        this.errorReader.start();
        this.entries = this.clParser.parse(this.in);
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getCommentFormat() {
        return this.commentFormat;
    }

    public void setCommentFormat(String commentFormat) {
        this.commentFormat = commentFormat;
    }

    public static void logExecute(Execute exe, File base) {
        String[] c = exe.getCommandline();
        LOG.info((CharSequence)("SCM Working Directory: " + base));
        for (int i = 0; i < c.length; ++i) {
            String string = c[i];
            LOG.info((CharSequence)("SCM Command Line[" + i + "]: " + string));
        }
    }
}

