/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.apt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:apt-maven-plugin:1.0-alpha-5", 0);
        this.append(sb, "", 0);
        this.append(sb, "Apt Maven Plugin", 0);
        this.append(sb, "Maven Plugin for Annotation Processing Tool (apt).", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "eclipse".equals(this.goal)) {
            this.append(sb, "apt:eclipse", 0);
            this.append(sb, "Generates Eclipse files for apt integration.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalSourceRoots", 2);
                this.append(sb, "The source directories containing any additional sources to be processed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ISO-8859-1)", 2);
                this.append(sb, "The source file encoding name, such as EUC-JP and UTF-8. If encoding is not specified, the encoding ISO-8859-1 is used rather than the platform default for reproducibility reasons. This is equivalent to the -encoding argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A set of exclusion filters for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "executable (Default: apt)", 2);
                this.append(sb, "The apt executable to use when forked.", 3);
                this.append(sb, "Expression: ${maven.apt.executable}", 3);
                this.append(sb, "", 0);
                this.append(sb, "factory", 2);
                this.append(sb, "Name of AnnotationProcessorFactory to use; bypasses default discovery process. This is equivalent to the -factory argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.factory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "Force apt processing without staleness checking. When false, use outputFiles or outputFileEndings to control computing staleness.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Whether to run apt in a separate process.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A set of inclusion filters for apt. Default value is **/*.java.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxmem", 2);
                this.append(sb, "The maximum size of the memory allocation pool when forked, for example 128m.", 3);
                this.append(sb, "", 0);
                this.append(sb, "meminitial", 2);
                this.append(sb, "The initial size of the memory allocation pool when forked, for example 64m.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "Options to pass to annotation processors. These are equivalent to multiple -A arguments for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-resources/apt)", 2);
                this.append(sb, "The directory to place processor and generated class files. This is equivalent to the -d argument for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileEndings", 2);
                this.append(sb, "The filename endings of processor-generated files to examine when computing staleness. For example, .txt would specify that the processor creates a corresponding .txt file for every .java source file. Default value is .java. Note that this parameter has no effect if outputFiles is specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFiles", 2);
                this.append(sb, "The filenames of processor-generated files to examine when computing staleness. For example, generated.xml would specify that the processor creates the aforementioned single file from all .java source files. When this parameter is not specified, outputFileEndings is used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceFiltering (Default: false)", 2);
                this.append(sb, "Whether resource filtering is enabled for processor-generated resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceTargetPath", 2);
                this.append(sb, "The path for processor-generated resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showWarnings (Default: false)", 2);
                this.append(sb, "Whether to show apt warnings. This is opposite to the -nowarn argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.showWarnings}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Whether to bypass running apt.", 3);
                this.append(sb, "Expression: ${maven.apt.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceOutputDirectory (Default: ${project.build.directory}/generated-sources/apt)", 2);
                this.append(sb, "The directory root under which processor-generated source files will be placed; files are placed in subdirectories based on package namespace. This is equivalent to the -s argument for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "Sets the granularity in milliseconds of the last modification date for testing whether a source needs processing.", 3);
                this.append(sb, "Expression: ${maven.apt.staleMillis}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Whether to output information about each class loaded and each source file processed. This is equivalent to the -verbose argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "apt:help", 0);
            this.append(sb, "Display help information on apt-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0apt:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "process".equals(this.goal)) {
            this.append(sb, "apt:process", 0);
            this.append(sb, "Executes apt on project sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalSourceRoots", 2);
                this.append(sb, "The source directories containing any additional sources to be processed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ISO-8859-1)", 2);
                this.append(sb, "The source file encoding name, such as EUC-JP and UTF-8. If encoding is not specified, the encoding ISO-8859-1 is used rather than the platform default for reproducibility reasons. This is equivalent to the -encoding argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A set of exclusion filters for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "executable (Default: apt)", 2);
                this.append(sb, "The apt executable to use when forked.", 3);
                this.append(sb, "Expression: ${maven.apt.executable}", 3);
                this.append(sb, "", 0);
                this.append(sb, "factory", 2);
                this.append(sb, "Name of AnnotationProcessorFactory to use; bypasses default discovery process. This is equivalent to the -factory argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.factory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "Force apt processing without staleness checking. When false, use outputFiles or outputFileEndings to control computing staleness.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Whether to run apt in a separate process.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A set of inclusion filters for apt. Default value is **/*.java.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxmem", 2);
                this.append(sb, "The maximum size of the memory allocation pool when forked, for example 128m.", 3);
                this.append(sb, "", 0);
                this.append(sb, "meminitial", 2);
                this.append(sb, "The initial size of the memory allocation pool when forked, for example 64m.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "Options to pass to annotation processors. These are equivalent to multiple -A arguments for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-resources/apt)", 2);
                this.append(sb, "The directory to place processor and generated class files. This is equivalent to the -d argument for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileEndings", 2);
                this.append(sb, "The filename endings of processor-generated files to examine when computing staleness. For example, .txt would specify that the processor creates a corresponding .txt file for every .java source file. Default value is .java. Note that this parameter has no effect if outputFiles is specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFiles", 2);
                this.append(sb, "The filenames of processor-generated files to examine when computing staleness. For example, generated.xml would specify that the processor creates the aforementioned single file from all .java source files. When this parameter is not specified, outputFileEndings is used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceFiltering (Default: false)", 2);
                this.append(sb, "Whether resource filtering is enabled for processor-generated resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceTargetPath", 2);
                this.append(sb, "The path for processor-generated resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showWarnings (Default: false)", 2);
                this.append(sb, "Whether to show apt warnings. This is opposite to the -nowarn argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.showWarnings}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Whether to bypass running apt.", 3);
                this.append(sb, "Expression: ${maven.apt.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceOutputDirectory (Default: ${project.build.directory}/generated-sources/apt)", 2);
                this.append(sb, "The directory root under which processor-generated source files will be placed; files are placed in subdirectories based on package namespace. This is equivalent to the -s argument for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "Sets the granularity in milliseconds of the last modification date for testing whether a source needs processing.", 3);
                this.append(sb, "Expression: ${maven.apt.staleMillis}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Whether to output information about each class loaded and each source file processed. This is equivalent to the -verbose argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-process".equals(this.goal)) {
            this.append(sb, "apt:test-process", 0);
            this.append(sb, "Executes apt on project test sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "additionalSourceRoots", 2);
                this.append(sb, "The source directories containing any additional sources to be processed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ISO-8859-1)", 2);
                this.append(sb, "The source file encoding name, such as EUC-JP and UTF-8. If encoding is not specified, the encoding ISO-8859-1 is used rather than the platform default for reproducibility reasons. This is equivalent to the -encoding argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A set of exclusion filters for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "executable (Default: apt)", 2);
                this.append(sb, "The apt executable to use when forked.", 3);
                this.append(sb, "Expression: ${maven.apt.executable}", 3);
                this.append(sb, "", 0);
                this.append(sb, "factory", 2);
                this.append(sb, "Name of AnnotationProcessorFactory to use; bypasses default discovery process. This is equivalent to the -factory argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.factory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "Force apt processing without staleness checking. When false, use outputFiles or outputFileEndings to control computing staleness.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Whether to run apt in a separate process.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A set of inclusion filters for apt. Default value is **/*.java.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxmem", 2);
                this.append(sb, "The maximum size of the memory allocation pool when forked, for example 128m.", 3);
                this.append(sb, "", 0);
                this.append(sb, "meminitial", 2);
                this.append(sb, "The initial size of the memory allocation pool when forked, for example 64m.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "Options to pass to annotation processors. These are equivalent to multiple -A arguments for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFileEndings", 2);
                this.append(sb, "The filename endings of processor-generated files to examine when computing staleness. For example, .txt would specify that the processor creates a corresponding .txt file for every .java source file. Default value is .java. Note that this parameter has no effect if outputFiles is specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFiles", 2);
                this.append(sb, "The filenames of processor-generated files to examine when computing staleness. For example, generated.xml would specify that the processor creates the aforementioned single file from all .java source files. When this parameter is not specified, outputFileEndings is used instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceFiltering (Default: false)", 2);
                this.append(sb, "Whether resource filtering is enabled for processor-generated resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceTargetPath", 2);
                this.append(sb, "The path for processor-generated resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showWarnings (Default: false)", 2);
                this.append(sb, "Whether to show apt warnings. This is opposite to the -nowarn argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.showWarnings}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Whether to bypass running apt.", 3);
                this.append(sb, "Expression: ${maven.apt.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "Sets the granularity in milliseconds of the last modification date for testing whether a source needs processing.", 3);
                this.append(sb, "Expression: ${maven.apt.staleMillis}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testOutputDirectory (Default: ${project.build.directory}/generated-test-resources/apt)", 2);
                this.append(sb, "The directory to place processor and generated class files. This is equivalent to the -d argument for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testSourceOutputDirectory (Default: ${project.build.directory}/generated-test-sources/apt)", 2);
                this.append(sb, "The directory root under which processor-generated test source files will be placed; files are placed in subdirectories based on package namespace. This is equivalent to the -s argument for apt.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Whether to output information about each class loaded and each source file processed. This is equivalent to the -verbose argument for apt.", 3);
                this.append(sb, "Expression: ${maven.apt.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

