/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

public final class MavenProjectUtils {
    private MavenProjectUtils() {
    }

    public static List getClasspathElements(MavenProject project, List artifacts) throws DependencyResolutionRequiredException {
        ArrayList list = new ArrayList(artifacts.size());
        Iterator iterator = artifacts.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            if (!artifact.getArtifactHandler().isAddedToClasspath() || !"compile".equals(artifact.getScope()) && !"provided".equals(artifact.getScope()) && !"system".equals(artifact.getScope())) continue;
            MavenProjectUtils.addArtifactPath(project, artifact, list);
        }
        return list;
    }

    private static void addArtifactPath(MavenProject project, Artifact artifact, List list) throws DependencyResolutionRequiredException {
        String refId = MavenProjectUtils.getProjectReferenceId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        MavenProject refProject = (MavenProject)project.getProjectReferences().get(refId);
        boolean projectDirFound = false;
        if (refProject != null) {
            if (artifact.getType().equals("test-jar")) {
                File testOutputDir = new File(refProject.getBuild().getTestOutputDirectory());
                if (testOutputDir.exists()) {
                    list.add(testOutputDir.getAbsolutePath());
                    projectDirFound = true;
                }
            } else {
                list.add(refProject.getBuild().getOutputDirectory());
                projectDirFound = true;
            }
        }
        if (!projectDirFound) {
            File file = artifact.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(artifact);
            }
            list.add(file.getPath());
        }
    }

    private static String getProjectReferenceId(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }
}

