/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.codehaus.modello.plugin.java.javasource.JAnnotations;
import org.codehaus.modello.plugin.java.javasource.JComment;
import org.codehaus.modello.plugin.java.javasource.JDocComment;
import org.codehaus.modello.plugin.java.javasource.JDocDescriptor;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JInterface;
import org.codehaus.modello.plugin.java.javasource.JMember;
import org.codehaus.modello.plugin.java.javasource.JModifiers;
import org.codehaus.modello.plugin.java.javasource.JNaming;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.plexus.util.WriterFactory;

public abstract class JStructure
extends JType {
    static final String DEFAULT_HEADER = "$Id$";
    static final String version = "$Revision$ $Date$";
    private JComment header = null;
    private Vector imports = null;
    private Vector interfaces = null;
    private JDocComment jdc = null;
    private JModifiers modifiers = null;
    private String packageName = null;
    private JAnnotations annotations = null;

    protected JStructure(String name) throws IllegalArgumentException {
        super(name);
        if (!JStructure.isValidClassName(name)) {
            String lname = this.getLocalName();
            String err = "'" + lname + "' is ";
            err = JNaming.isKeyword(lname) ? err + "a reserved word and may not be used as  a class name." : err + "not a valid Java identifier.";
            throw new IllegalArgumentException(err);
        }
        this.packageName = JStructure.getPackageFromClassName(name);
        this.imports = new Vector();
        this.interfaces = new Vector();
        this.jdc = new JDocComment();
        this.modifiers = new JModifiers();
        this.jdc.addDescriptor(JDocDescriptor.createVersionDesc(version));
    }

    public abstract void addField(JField var1) throws IllegalArgumentException;

    public abstract void addMember(JMember var1) throws IllegalArgumentException;

    public void addImport(String className) {
        if (className == null) {
            return;
        }
        if (className.length() == 0) {
            return;
        }
        String pkgName = JStructure.getPackageFromClassName(className);
        if (pkgName != null) {
            if (pkgName.equals(this.packageName)) {
                return;
            }
            if (pkgName.equals("java.lang")) {
                return;
            }
            for (int i = 0; i < this.imports.size(); ++i) {
                String imp = (String)this.imports.elementAt(i);
                if (imp.equals(className)) {
                    return;
                }
                if (imp.compareTo(className) <= 0) continue;
                this.imports.insertElementAt(className, i);
                return;
            }
            this.imports.addElement(className);
        }
    }

    public void addInterface(String interfaceName) {
        if (!this.interfaces.contains(interfaceName)) {
            this.interfaces.addElement(interfaceName);
        }
    }

    public void addInterface(JInterface jInterface) {
        if (jInterface == null) {
            return;
        }
        String interfaceName = jInterface.getName();
        if (!this.interfaces.contains(interfaceName)) {
            this.interfaces.addElement(interfaceName);
        }
    }

    public abstract JField getField(String var1);

    public abstract JField[] getFields();

    public String getFilename(String destDir) {
        File pathFile;
        String filename = this.getLocalName() + ".java";
        String javaPackagePath = "";
        if (this.packageName != null && this.packageName.length() > 0) {
            javaPackagePath = this.packageName.replace('.', File.separatorChar);
        }
        if (!(pathFile = destDir == null ? new File(javaPackagePath) : new File(destDir, javaPackagePath)).exists()) {
            pathFile.mkdirs();
        }
        if (pathFile.toString().length() > 0) {
            filename = pathFile.toString() + File.separator + filename;
        }
        return filename;
    }

    public JComment getHeader() {
        return this.header;
    }

    public Enumeration getImports() {
        return this.imports.elements();
    }

    public Enumeration getInterfaces() {
        return this.interfaces.elements();
    }

    public JDocComment getJDocComment() {
        return this.jdc;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName(boolean stripPackage) {
        int period;
        String name = super.getName();
        if (stripPackage && (period = name.lastIndexOf(".")) > 0) {
            name = name.substring(period + 1);
        }
        return name;
    }

    public boolean hasImport(String classname) {
        return this.imports.contains(classname);
    }

    public boolean removeImport(String className) {
        boolean result = false;
        if (className == null) {
            return result;
        }
        if (className.length() == 0) {
            return result;
        }
        result = this.imports.removeElement(className);
        return result;
    }

    public boolean isAbstract() {
        return this.modifiers.isAbstract();
    }

    public static boolean isValidClassName(String name) {
        if (name == null) {
            return false;
        }
        int period = name.lastIndexOf(".");
        if (period > 0) {
            name = name.substring(period + 1);
        }
        return JNaming.isValidJavaIdentifier(name);
    }

    public void print() {
        this.print(null, null);
    }

    public void print(String destDir, String lineSeparator) {
        String filename = this.getFilename(destDir);
        File file = new File(filename);
        JSourceWriter jsw = null;
        try {
            jsw = new JSourceWriter(WriterFactory.newPlatformWriter((File)file));
        }
        catch (IOException ioe) {
            System.out.println("unable to create class file: " + filename);
            return;
        }
        if (lineSeparator == null) {
            lineSeparator = System.getProperty("line.separator");
        }
        jsw.setLineSeparator(lineSeparator);
        this.print(jsw);
        jsw.close();
    }

    public abstract void print(JSourceWriter var1);

    public void printHeader(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        JComment header = this.getHeader();
        if (header != null) {
            header.print(jsw);
        } else {
            jsw.writeln("/*");
            jsw.writeln(" * $Id$");
            jsw.writeln(" */");
        }
        jsw.writeln();
        jsw.flush();
    }

    public void printImportDeclarations(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        if (this.imports.size() > 0) {
            jsw.writeln("  //---------------------------------/");
            jsw.writeln(" //- Imported classes and packages -/");
            jsw.writeln("//---------------------------------/");
            jsw.writeln();
            Enumeration e = this.imports.elements();
            while (e.hasMoreElements()) {
                jsw.write("import ");
                jsw.write(e.nextElement());
                jsw.writeln(';');
            }
            jsw.writeln();
            jsw.flush();
        }
    }

    public void printPackageDeclaration(JSourceWriter jsw) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        if (this.packageName != null && this.packageName.length() > 0) {
            jsw.write("package ");
            jsw.write(this.packageName);
            jsw.writeln(';');
            jsw.writeln();
        }
        jsw.flush();
    }

    public void setHeader(JComment comment) {
        this.header = comment;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.changePackage(packageName);
    }

    protected int getInterfaceCount() {
        return this.interfaces.size();
    }

    protected static void printlnWithPrefix(String prefix, String source, JSourceWriter jsw) {
        jsw.write(prefix);
        if (source == null) {
            return;
        }
        char[] chars = source.toCharArray();
        int lastIdx = 0;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch != '\n') continue;
            jsw.write(chars, lastIdx, i - lastIdx + 1);
            lastIdx = i + 1;
            if (i >= chars.length) continue;
            jsw.write(prefix);
        }
        if (lastIdx < chars.length) {
            jsw.write(chars, lastIdx, chars.length - lastIdx);
        }
        jsw.writeln();
    }

    protected static String getPackageFromClassName(String className) {
        int idx = -1;
        idx = className.lastIndexOf(46);
        if (idx > 0) {
            return className.substring(0, idx);
        }
        return null;
    }

    public JAnnotations getAnnotations() {
        return this.annotations;
    }

    public void appendAnnotation(String annotation) {
        if (this.annotations == null) {
            this.annotations = new JAnnotations();
        }
        this.annotations.appendAnnotation(annotation);
    }

    public void setAnnotations(JAnnotations annotations) {
        this.annotations = annotations;
    }
}

