/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBeanDescription
extends BeanDescription {
    final AnnotatedClass _classInfo;
    final AnnotationIntrospector _annotationIntrospector;

    public BasicBeanDescription(JavaType type, AnnotatedClass ac, AnnotationIntrospector ai) {
        super(type);
        this._classInfo = ac;
        this._annotationIntrospector = ai;
    }

    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        return this._classInfo.findMethod(name, paramTypes);
    }

    public Object instantiateBean(boolean fixAccess) {
        AnnotatedConstructor ac = this._classInfo.getDefaultConstructor();
        if (ac == null) {
            return null;
        }
        if (fixAccess) {
            ac.fixAccess();
        }
        try {
            return ((Constructor)ac.getAnnotated()).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IllegalArgumentException("Failed to instantiate bean of type " + ((Class)this._classInfo.getAnnotated()).getName() + ": (" + t.getClass().getName() + ") " + t.getMessage(), t);
        }
    }

    @Override
    public LinkedHashMap<String, AnnotatedMethod> findGetters(boolean autodetect, Collection<String> ignoredProperties) {
        Boolean classAD = this._annotationIntrospector.findGetterAutoDetection(this._classInfo);
        if (classAD != null) {
            autodetect = classAD;
        }
        LinkedHashMap<String, AnnotatedMethod> results = new LinkedHashMap<String, AnnotatedMethod>();
        for (AnnotatedMethod am : this._classInfo.memberMethods()) {
            AnnotatedMethod old;
            if (am.getParameterCount() != 0) continue;
            String propName = this._annotationIntrospector.findGettablePropertyName(am);
            if (propName != null) {
                if (propName.length() == 0 && (propName = this.okNameForGetter(am)) == null) {
                    propName = am.getName();
                }
            } else if (!autodetect || !am.isPublic() || (propName = this.okNameForGetter(am)) == null) continue;
            if (ignoredProperties != null && ignoredProperties.contains(propName) || (old = results.put(propName, am)) == null) continue;
            String oldDesc = old.getFullName();
            String newDesc = am.getFullName();
            throw new IllegalArgumentException("Conflicting getter definitions for property \"" + propName + "\": " + oldDesc + " vs " + newDesc);
        }
        return results;
    }

    public AnnotatedMethod findJsonValueMethod() {
        AnnotatedMethod found = null;
        for (AnnotatedMethod am : this._classInfo.memberMethods()) {
            if (!this._annotationIntrospector.hasAsValueAnnotation(am)) continue;
            if (found != null) {
                throw new IllegalArgumentException("Multiple methods with active 'as-value' annotation (" + found.getName() + "(), " + am.getName() + ")");
            }
            if (!ClassUtil.hasGetterSignature(am.getAnnotated())) {
                throw new IllegalArgumentException("Method " + am.getName() + "() marked with an 'as-value' annotation, but does not have valid getter signature (non-static, takes no args, returns a value)");
            }
            found = am;
        }
        return found;
    }

    public Constructor<?> findDefaultConstructor() {
        AnnotatedConstructor ac = this._classInfo.getDefaultConstructor();
        if (ac == null) {
            return null;
        }
        return ac.getAnnotated();
    }

    public Constructor<?> findSingleArgConstructor(Class<?> ... argTypes) {
        for (AnnotatedConstructor ac : this._classInfo.getSingleArgConstructors()) {
            Class<?>[] args = ac.getParameterTypes();
            if (args.length != 1) continue;
            Class<?> actArg = args[0];
            for (Class<?> expArg : argTypes) {
                if (expArg != actArg) continue;
                return ac.getAnnotated();
            }
        }
        return null;
    }

    public Method findFactoryMethod(Class<?> ... expArgTypes) {
        for (AnnotatedMethod am : this._classInfo.getSingleArgStaticMethods()) {
            if (am.getReturnType() != this.getBeanClass() || !this._annotationIntrospector.hasCreatorAnnotation(am) && !"valueOf".equals(am.getName())) continue;
            Class<?> actualArgType = am.getParameterTypes()[0];
            for (Class<?> expArgType : expArgTypes) {
                if (!actualArgType.isAssignableFrom(expArgType)) continue;
                return am.getAnnotated();
            }
        }
        return null;
    }

    public LinkedHashMap<String, AnnotatedField> findSerializableFields(boolean autodetect, Collection<String> ignoredProperties) {
        return this._findPropertyFields(autodetect, ignoredProperties, true);
    }

    public JsonSerialize.Inclusion findSerializationInclusion(JsonSerialize.Inclusion defValue) {
        return this._annotationIntrospector.findSerializationInclusion(this._classInfo, defValue);
    }

    @Override
    public LinkedHashMap<String, AnnotatedMethod> findSetters(boolean autodetect) {
        Boolean classAD = this._annotationIntrospector.findSetterAutoDetection(this._classInfo);
        if (classAD != null) {
            autodetect = classAD;
        }
        LinkedHashMap<String, AnnotatedMethod> results = new LinkedHashMap<String, AnnotatedMethod>();
        for (AnnotatedMethod am : this._classInfo.memberMethods()) {
            AnnotatedMethod old;
            if (am.getParameterCount() != 1) continue;
            String propName = this._annotationIntrospector.findSettablePropertyName(am);
            if (propName != null) {
                if (propName.length() == 0 && (propName = this.okNameForSetter(am)) == null) {
                    propName = am.getName();
                }
            } else if (!autodetect || (propName = this.okNameForSetter(am)) == null) continue;
            if ((old = results.put(propName, am)) == null) continue;
            String oldDesc = old.getFullName();
            String newDesc = am.getFullName();
            throw new IllegalArgumentException("Conflicting setter definitions for property \"" + propName + "\": " + oldDesc + " vs " + newDesc);
        }
        return results;
    }

    public AnnotatedMethod findAnySetter() throws IllegalArgumentException {
        AnnotatedMethod found = null;
        for (AnnotatedMethod am : this._classInfo.memberMethods()) {
            if (!this._annotationIntrospector.hasAnySetterAnnotation(am)) continue;
            if (found != null) {
                throw new IllegalArgumentException("Multiple methods with 'any-setter' annotation (" + found.getName() + "(), " + am.getName() + ")");
            }
            int pcount = am.getParameterCount();
            if (pcount != 2) {
                throw new IllegalArgumentException("Invalid 'any-setter' annotation on method " + am.getName() + "(): takes " + pcount + " parameters, should take 2");
            }
            Class<?> type = am.getParameterTypes()[0];
            if (type != String.class && type != Object.class) {
                throw new IllegalArgumentException("Invalid 'any-setter' annotation on method " + am.getName() + "(): first argument not of type String or Object, but " + type.getName());
            }
            found = am;
        }
        return found;
    }

    public LinkedHashMap<String, AnnotatedField> findDeserializableFields(boolean autodetect, Collection<String> ignoredProperties) {
        return this._findPropertyFields(autodetect, ignoredProperties, false);
    }

    protected String okNameForGetter(AnnotatedMethod am) {
        String name = am.getName();
        if (name.startsWith("get")) {
            if ("getCallbacks".equals(name) ? this.isCglibGetCallbacks(am) : "getMetaClass".equals(name) && this.isGroovyMeta(am)) {
                return null;
            }
            return this.mangleGetterName(am, name.substring(3));
        }
        if (name.startsWith("is")) {
            Class<?> rt = am.getReturnType();
            if (rt != Boolean.class && rt != Boolean.TYPE) {
                return null;
            }
            return this.mangleGetterName(am, name.substring(2));
        }
        return null;
    }

    protected String mangleGetterName(Annotated a, String basename) {
        return BasicBeanDescription.manglePropertyName(basename);
    }

    protected boolean isCglibGetCallbacks(AnnotatedMethod am) {
        Class<?> rt = am.getReturnType();
        if (rt == null || !rt.isArray()) {
            return false;
        }
        Class<?> compType = rt.getComponentType();
        Package pkg = compType.getPackage();
        return pkg != null && pkg.getName().startsWith("net.sf.cglib");
    }

    protected boolean isGroovyMeta(AnnotatedMethod am) {
        Class<?> rt = am.getReturnType();
        if (rt == null || rt.isArray()) {
            return false;
        }
        Package pkg = rt.getPackage();
        return pkg != null && pkg.getName().startsWith("groovy.lang");
    }

    protected String okNameForSetter(AnnotatedMethod am) {
        String name = am.getName();
        if (name.startsWith("set")) {
            if ((name = this.mangleSetterName(am, name.substring(3))) == null) {
                return null;
            }
            return name;
        }
        return null;
    }

    protected String mangleSetterName(Annotated a, String basename) {
        return BasicBeanDescription.manglePropertyName(basename);
    }

    public LinkedHashMap<String, AnnotatedField> _findPropertyFields(boolean autodetect, Collection<String> ignoredProperties, boolean forSerialization) {
        Boolean classAD = this._annotationIntrospector.findFieldAutoDetection(this._classInfo);
        if (classAD != null) {
            autodetect = classAD;
        }
        LinkedHashMap<String, AnnotatedField> results = new LinkedHashMap<String, AnnotatedField>();
        for (AnnotatedField af : this._classInfo.fields()) {
            AnnotatedField old;
            String propName;
            String string = propName = forSerialization ? this._annotationIntrospector.findSerializablePropertyName(af) : this._annotationIntrospector.findDeserializablePropertyName(af);
            if (propName != null) {
                if (propName.length() == 0) {
                    propName = af.getName();
                }
            } else {
                if (!autodetect || !af.isPublic()) continue;
                propName = af.getName();
            }
            if (ignoredProperties != null && ignoredProperties.contains(propName) || (old = results.put(propName, af)) == null) continue;
            String oldDesc = old.getFullName();
            String newDesc = af.getFullName();
            throw new IllegalArgumentException("Multiple fields representing property \"" + propName + "\": " + oldDesc + " vs " + newDesc);
        }
        return results;
    }

    public static String manglePropertyName(String basename) {
        char lower;
        char upper;
        int len = basename.length();
        if (len == 0) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < len && (upper = basename.charAt(i)) != (lower = Character.toLowerCase(upper)); ++i) {
            if (sb == null) {
                sb = new StringBuilder(basename);
            }
            sb.setCharAt(i, lower);
        }
        return sb == null ? basename : sb.toString();
    }

    public static String descFor(AnnotatedElement elem) {
        if (elem instanceof Class) {
            return "class " + ((Class)elem).getName();
        }
        if (elem instanceof Method) {
            Method m = (Method)elem;
            return "method " + m.getName() + " (from class " + m.getDeclaringClass().getName() + ")";
        }
        if (elem instanceof Constructor) {
            Constructor ctor = (Constructor)elem;
            return "constructor() (from class " + ctor.getDeclaringClass().getName() + ")";
        }
        return "unknown type [" + elem.getClass() + "]";
    }
}

