/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.annotate.JsonCachable;
import org.codehaus.jackson.map.deser.EnumResolver;
import org.codehaus.jackson.map.deser.StdDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonCachable
public class EnumDeserializer
extends StdDeserializer<Enum<?>> {
    final EnumResolver _resolver;

    public EnumDeserializer(EnumResolver res) {
        super(Enum.class);
        this._resolver = res;
    }

    @Override
    public Enum<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            String name = jp.getText();
            Enum<?> result = this._resolver.findEnum(name);
            if (result == null) {
                throw ctxt.weirdStringException(this._resolver.getEnumClass(), "value not one of declared Enum instance names");
            }
            return result;
        }
        if (curr == JsonToken.VALUE_NUMBER_INT) {
            int index = jp.getIntValue();
            Enum<?> result = this._resolver.getEnum(index);
            if (result == null) {
                throw ctxt.weirdNumberException(this._resolver.getEnumClass(), "index value outside legal index range [0.." + this._resolver.lastValidIndex() + "]");
            }
            return result;
        }
        throw ctxt.mappingException(this._resolver.getEnumClass());
    }
}

