/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

class JDTClassNodeBuilder {
    private JDTResolver resolver;
    private Map<TypeVariableBinding, ClassNode> typeVariableConfigurationInProgress = new HashMap<TypeVariableBinding, ClassNode>();

    public static ClassNode build(JDTResolver resolver, TypeBinding typeBinding) {
        JDTClassNodeBuilder builder = new JDTClassNodeBuilder(resolver);
        return builder.configureType(typeBinding);
    }

    public ClassNode configureType(TypeBinding type) {
        if (type instanceof UnresolvedReferenceBinding) {
            type = this.resolver.getScope().environment.askForType(((UnresolvedReferenceBinding)type).compoundName);
        }
        if (type instanceof TypeVariableBinding) {
            return this.configureTypeVariableReference((TypeVariableBinding)type);
        }
        if (type instanceof ParameterizedTypeBinding) {
            return this.configureParameterizedType((ParameterizedTypeBinding)type);
        }
        if (type instanceof BinaryTypeBinding) {
            return this.configureClass((BinaryTypeBinding)type);
        }
        if (type instanceof WildcardBinding) {
            return this.configureWildcardType((WildcardBinding)type);
        }
        if (type instanceof ArrayBinding) {
            return this.configureGenericArray((ArrayBinding)type);
        }
        if (type instanceof BaseTypeBinding) {
            return this.configureBaseTypeBinding((BaseTypeBinding)type);
        }
        if (type instanceof SourceTypeBinding) {
            return this.configureSourceType((SourceTypeBinding)type);
        }
        throw new IllegalStateException("nyi " + (type == null ? "null" : type.getClass()));
    }

    JDTClassNodeBuilder(JDTResolver resolver) {
        this.resolver = resolver;
    }

    GenericsType[] configureTypeVariables(TypeVariableBinding[] tvs) {
        if (tvs.length == 0) {
            return null;
        }
        GenericsType[] gts = new GenericsType[tvs.length];
        int i = 0;
        while (i < tvs.length) {
            gts[i] = this.configureTypeVariableDefinition(tvs[i]);
            ++i;
        }
        return gts;
    }

    GenericsType[] configureTypeArguments(TypeBinding[] ta) {
        if (ta == null) {
            return null;
        }
        if (ta.length == 0) {
            return null;
        }
        GenericsType[] gts = new GenericsType[ta.length];
        int i = 0;
        while (i < ta.length) {
            ClassNode t = this.configureType(ta[i]);
            if (ta[i] instanceof WildcardBinding) {
                GenericsType[] gen = t.getGenericsTypes();
                gts[i] = gen[0];
            } else {
                gts[i] = new GenericsType(t);
            }
            ++i;
        }
        return gts;
    }

    TypeBinding toRawType(TypeBinding tb) {
        if (tb instanceof RawTypeBinding) {
            return tb;
        }
        if (tb instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding ptb = (ParameterizedTypeBinding)tb;
            return ptb.environment().convertToRawType(ptb.genericType(), false);
        }
        if (tb instanceof TypeVariableBinding) {
            TypeBinding fb = ((TypeVariableBinding)tb).firstBound;
            if (fb == null) {
                return tb.erasure();
            }
            return fb;
        }
        if (tb instanceof BinaryTypeBinding) {
            if (tb.isGenericType()) {
                try {
                    Field f = BinaryTypeBinding.class.getDeclaredField("environment");
                    f.setAccessible(true);
                    LookupEnvironment le = (LookupEnvironment)f.get(tb);
                    return le.convertToRawType(tb, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem building rawtype ", e);
                }
            }
            return tb;
        }
        if (tb instanceof ArrayBinding) {
            return tb;
        }
        if (tb instanceof BaseTypeBinding) {
            return tb;
        }
        if (tb instanceof SourceTypeBinding) {
            return tb;
        }
        throw new IllegalStateException("nyi " + tb.getClass());
    }

    private ClassNode[] configureTypes(TypeBinding[] types) {
        if (types.length == 0) {
            return null;
        }
        ClassNode[] nodes = new ClassNode[types.length];
        int i = 0;
        while (i < types.length) {
            nodes[i] = this.configureType(types[i]);
            ++i;
        }
        return nodes;
    }

    private ClassNode configureBaseTypeBinding(BaseTypeBinding type) {
        switch (type.id) {
            case 5: {
                return ClassHelper.boolean_TYPE;
            }
            case 2: {
                return ClassHelper.char_TYPE;
            }
            case 3: {
                return ClassHelper.byte_TYPE;
            }
            case 4: {
                return ClassHelper.short_TYPE;
            }
            case 10: {
                return ClassHelper.int_TYPE;
            }
            case 7: {
                return ClassHelper.long_TYPE;
            }
            case 8: {
                return ClassHelper.double_TYPE;
            }
            case 9: {
                return ClassHelper.float_TYPE;
            }
            case 6: {
                return ClassHelper.VOID_TYPE;
            }
        }
        throw new GroovyEclipseBug("Unexpected BaseTypeBinding: " + type + "(type.id=" + type.id + ")");
    }

    private ClassNode configureGenericArray(ArrayBinding genericArrayType) {
        TypeBinding component = genericArrayType.leafComponentType;
        ClassNode node = this.configureType(component);
        int dims = genericArrayType.dimensions;
        ClassNode result = node;
        int d = 0;
        while (d < dims) {
            result = result.makeArray();
            ++d;
        }
        return result;
    }

    private ClassNode configureTypeVariableReference(TypeVariableBinding tv) {
        ClassNode nodeInProgress = this.typeVariableConfigurationInProgress.get(tv);
        if (nodeInProgress != null) {
            return nodeInProgress;
        }
        ClassNode cn = ClassHelper.makeWithoutCaching(tv.debugName());
        cn.setGenericsPlaceHolder(true);
        ClassNode cn2 = ClassHelper.makeWithoutCaching(tv.debugName());
        cn2.setGenericsPlaceHolder(true);
        GenericsType[] gts = new GenericsType[]{new GenericsType(cn2)};
        cn.setGenericsTypes(gts);
        cn.setRedirect(ClassHelper.OBJECT_TYPE);
        this.typeVariableConfigurationInProgress.put(tv, cn);
        TypeBinding tb = tv.firstBound;
        if (tb != null && !tb.debugName().equals("java.lang.Object")) {
            ClassNode back = this.configureType(tb);
            cn.setRedirect(back);
        }
        this.typeVariableConfigurationInProgress.remove(tv);
        return cn;
    }

    private GenericsType configureTypeVariableDefinition(TypeVariableBinding tv) {
        GenericsType gt;
        ClassNode base = this.configureTypeVariableReference(tv);
        ClassNode redirect = base.redirect();
        base.setRedirect(null);
        TypeBinding[] tBounds = this.getBounds(tv);
        if (tBounds.length == 0) {
            gt = new GenericsType(base);
        } else {
            ClassNode[] cBounds = this.configureTypes(tBounds);
            gt = new GenericsType(base, cBounds, null);
            gt.setName(base.getName());
            gt.setPlaceholder(true);
        }
        base.setRedirect(redirect);
        return gt;
    }

    private TypeBinding[] getBounds(TypeVariableBinding tv) {
        ArrayList<TypeBinding> bounds = new ArrayList<TypeBinding>();
        if (tv.firstBound == null) {
            TypeBinding erasure = tv.erasure();
            if (erasure == null) {
                erasure = this.resolver.getScope().getJavaLangObject();
            }
            return new TypeBinding[]{erasure};
        }
        bounds.add(tv.firstBound);
        TypeBinding[] obs = tv.otherUpperBounds();
        int i = 0;
        while (i < obs.length) {
            bounds.add(obs[i]);
            ++i;
        }
        return bounds.toArray(new TypeBinding[bounds.size()]);
    }

    private ClassNode configureWildcardType(WildcardBinding wildcardType) {
        ClassNode base = ClassHelper.makeWithoutCaching("?");
        base.setRedirect(ClassHelper.OBJECT_TYPE);
        ClassNode[] lowers = this.configureTypes(this.getLowerbounds(wildcardType));
        ClassNode lower = null;
        if (lowers != null) {
            lower = lowers[0];
        }
        ClassNode[] upper = this.configureTypes(this.getUpperbounds(wildcardType));
        GenericsType t = new GenericsType(base, upper, lower);
        t.setWildcard(true);
        ClassNode ref = ClassHelper.makeWithoutCaching(Object.class, false);
        ref.setGenericsTypes(new GenericsType[]{t});
        return ref;
    }

    private TypeBinding[] getLowerbounds(WildcardBinding wildcardType) {
        if (wildcardType.boundKind == 2) {
            return new TypeBinding[]{wildcardType.bound};
        }
        return TypeBinding.NO_TYPES;
    }

    private TypeBinding[] getUpperbounds(WildcardBinding wildcardType) {
        if (wildcardType.boundKind == 1) {
            ArrayList<TypeBinding> bounds = new ArrayList<TypeBinding>();
            bounds.add(wildcardType.bound);
            if (wildcardType.otherBounds != null) {
                int b = 0;
                while (b < wildcardType.otherBounds.length) {
                    bounds.add(wildcardType.otherBounds[b]);
                    ++b;
                }
            }
            return bounds.toArray(new TypeBinding[bounds.size()]);
        }
        return new TypeBinding[]{wildcardType.erasure()};
    }

    private ClassNode configureParameterizedType(ParameterizedTypeBinding parameterizedType) {
        if (parameterizedType instanceof RawTypeBinding) {
            TypeBinding rt = this.toRawType(parameterizedType);
            if (!(rt instanceof RawTypeBinding)) {
                System.out.println("yikes");
            }
            return new JDTClassNode((RawTypeBinding)rt, this.resolver);
        }
        TypeBinding rt = this.toRawType(parameterizedType);
        if (rt instanceof ParameterizedTypeBinding && !(rt instanceof RawTypeBinding)) {
            return new JDTClassNode((ParameterizedTypeBinding)rt, this.resolver);
        }
        ClassNode base = this.configureType(rt);
        if (base instanceof JDTClassNode) {
            ((JDTClassNode)base).setJdtBinding(parameterizedType);
            if (!(parameterizedType instanceof RawTypeBinding)) {
                ClassNode cn = this.configureType(parameterizedType.genericType());
                ((JDTClassNode)base).setRedirect(cn);
            }
        }
        GenericsType[] gts = this.configureTypeArguments(parameterizedType.arguments);
        base.setGenericsTypes(gts);
        return base;
    }

    private ClassNode configureClass(BinaryTypeBinding type) {
        if (type.id == 1) {
            return ClassHelper.OBJECT_TYPE;
        }
        if (type.id == 11) {
            return ClassHelper.STRING_TYPE;
        }
        if (type.id == 16) {
            return ClassHelper.CLASS_Type;
        }
        JDTClassNode jcn = new JDTClassNode(type, this.resolver);
        return jcn;
    }

    private ClassNode configureSourceType(SourceTypeBinding type) {
        JDTClassNode jcn = new JDTClassNode(type, this.resolver);
        return jcn;
    }
}

