/*
 * Copyright 2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.codehaus.groovy.transform.powerassert;

import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.control.SourceUnit;

/**
 * Indicates that the source text for an assertion statement is not available.
 *
 * @author Peter Niederwieser
 */
public class SourceTextNotAvailableException extends RuntimeException {
    // only accepts AssertStatementS so that better error messages can be produced
    public SourceTextNotAvailableException(AssertStatement stat, SourceUnit unit, String msg) {
        super(String.format("%s for %s at (%d,%d)-(%d,%d) in %s",
                msg, stat.getBooleanExpression().getText(), stat.getLineNumber(), stat.getColumnNumber(),
                stat.getLastLineNumber(), stat.getLastColumnNumber(), unit.getName()));
    }
}
