/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.feature.support;

import org.codehaus.gmaven.feature.Component;
import org.codehaus.gmaven.feature.Configuration;
import org.codehaus.gmaven.feature.Feature;
import org.codehaus.gmaven.feature.FeatureException;
import org.codehaus.gmaven.feature.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureSupport
implements Feature {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String key;
    protected final Configuration config;
    protected final boolean supported;
    protected Provider provider;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected FeatureSupport(String key, boolean supported) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        this.key = key;
        this.supported = supported;
        this.config = new Configuration();
    }

    protected FeatureSupport(String key) {
        this(key, true);
    }

    public String toString() {
        return FeatureSupport.asString(this);
    }

    public int hashCode() {
        return this.key().hashCode();
    }

    public String key() {
        return this.key;
    }

    public String name() {
        return this.key();
    }

    public boolean supported() {
        return this.supported;
    }

    public void require() {
        if (!this.supported()) {
            throw new FeatureException("Feature not supported: " + this.key());
        }
    }

    public Configuration config() {
        return this.config;
    }

    public Component create(Configuration context) throws Exception {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        Component component = this.create();
        Configuration c = component.config();
        c.merge(context);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component create() throws Exception {
        this.require();
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.provider().getClass().getClassLoader());
        try {
            Component component = this.doCreate();
            Configuration c = component.config();
            c.merge(this.config());
            Component component2 = component;
            return component2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
    }

    protected abstract Component doCreate() throws Exception;

    synchronized void register(Provider provider) {
        if (this.provider != null) {
            throw new IllegalStateException("Duplicate provider registration with feature: " + this + ", previous provider: " + this.provider + ", current provider: " + provider);
        }
        this.provider = provider;
    }

    protected synchronized Provider provider() {
        if (this.provider == null) {
            throw new IllegalStateException("Provider has not been registered with feature: " + this);
        }
        return this.provider;
    }

    public static String asString(Feature feature) {
        if (!$assertionsDisabled && feature == null) {
            throw new AssertionError();
        }
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        buff.append(feature.key());
        buff.append("]");
        if (feature.key() != feature.name()) {
            buff.append(" '");
            buff.append(feature.name());
            buff.append("'");
        }
        buff.append(" (supported: ");
        buff.append(feature.supported());
        buff.append(", type: ");
        buff.append(feature.getClass().getName());
        buff.append(")");
        return buff.toString();
    }

    static {
        $assertionsDisabled = !FeatureSupport.class.desiredAssertionStatus();
    }
}

