/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.admin.helpers;

import java.util.Enumeration;
import java.util.Set;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiEntitiesListener;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.ui.admin.helpers.AdminBeanConstant;
import org.chorem.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import org.chorem.vradi.ui.admin.loadors.GroupUsersNodeLoadors;
import org.chorem.vradi.ui.admin.loadors.GroupsNodeLoadors;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import org.chorem.vradi.ui.tree.VradiTreeNode;

public class GroupNavigationTreeHelper
extends AdminNavigationTreeHelper<Group> {
    private static final Log log = LogFactory.getLog(GroupNavigationTreeHelper.class);
    protected VradiEntitiesListener<User> userVradiEntitiesListener;

    public GroupNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
        VradiContext.get().getVradiNotifier().addVradiListener(Group.class, this);
        this.userVradiEntitiesListener = new VradiEntitiesListener<User>(){

            @Override
            public void entitiesAdded(Set<User> added) {
                for (User user : added) {
                    String wikittyId = user.getWikittyId();
                    VradiTreeNode existingNode = GroupNavigationTreeHelper.this.findNode(GroupNavigationTreeHelper.this.getRootNode(), wikittyId);
                    if (existingNode == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"User modification occured");
                    }
                    GroupNavigationTreeHelper.this.refresh(existingNode);
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removedIds) {
                GroupNavigationTreeHelper.this.removeEntities(removedIds);
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(User.class, this.userVradiEntitiesListener);
    }

    @Override
    public VradiTreeNode createNode() {
        return new VradiTreeNode(String.class, AdminBeanConstant.GROUP.getCategoryName(), null, new GroupsNodeLoadors());
    }

    @Override
    public void createEntityNode(String wikittyId) {
        this.createGroupNode(wikittyId, false);
    }

    @Override
    public void entitiesAdded(Set<Group> added) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Groups added");
        }
        for (Group group : added) {
            String wikittyId = group.getWikittyId();
            VradiTreeNode existingNode = this.findNode(this.getRootNode(), wikittyId);
            if (existingNode != null) {
                this.refresh(existingNode);
                Set userIds = group.getUser();
                VradiTreeNode userCategory = this.findNode(existingNode, AdminBeanConstant.USER.getCategoryName());
                if (userCategory != null) {
                    Enumeration childrenEnum = userCategory.children();
                    while (childrenEnum.hasMoreElements()) {
                        VradiTreeNode child = (VradiTreeNode)((Object)childrenEnum.nextElement());
                        if (userIds != null && userIds.contains(child.getId())) continue;
                        this.removeNode((NavNode)child);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"User category not found");
                    }
                    userCategory = new VradiTreeNode(String.class, AdminBeanConstant.USER.getCategoryName(), null, (NavTreeNodeChildLoador)NavHelper.getChildLoador(GroupUsersNodeLoadors.class));
                    this.insertNode((NavNode)existingNode, (NavNode)userCategory);
                    return;
                }
                if (userIds == null) continue;
                for (String userId : userIds) {
                    VradiTreeNode userNode = this.findNode(existingNode, userId);
                    if (userNode != null) continue;
                    userNode = new VradiTreeNode(User.class, userId, null, null);
                    this.insertNode((NavNode)userCategory, (NavNode)userNode);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Create user node");
                }
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Create group node");
            }
            this.createEntityNode(wikittyId);
        }
    }
}

