/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.admin.helpers;

import java.util.Date;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.ClientImpl;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.GroupImpl;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.entities.UserImpl;
import org.chorem.vradi.entities.WebHarvestStream;
import org.chorem.vradi.entities.WebHarvestStreamImpl;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.entities.XmlStreamImpl;
import org.chorem.vradi.ui.admin.content.AdminClientUI;
import org.chorem.vradi.ui.admin.content.AdminFormTypeUI;
import org.chorem.vradi.ui.admin.content.AdminGroupUI;
import org.chorem.vradi.ui.admin.content.AdminStatusUI;
import org.chorem.vradi.ui.admin.content.AdminUserUI;
import org.chorem.vradi.ui.admin.content.AdminXmlStreamUI;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.WikittyExtension;

public enum AdminBeanConstant {
    CLIENT(I18n.n_((String)"vradi.client.category", (Object[])new Object[0]), I18n.n_((String)"vradi.adminClient.newClientName", (Object[])new Object[0]), Client.class, AdminClientUI.class),
    GROUP(I18n.n_((String)"vradi.group.category", (Object[])new Object[0]), I18n.n_((String)"vradi.adminGroup.newGroupName", (Object[])new Object[0]), Group.class, AdminGroupUI.class),
    USER(I18n.n_((String)"vradi.user.category", (Object[])new Object[0]), I18n.n_((String)"vradi.adminUser.newUserName", (Object[])new Object[0]), User.class, AdminUserUI.class),
    STATUS(I18n.n_((String)"vradi.status.category", (Object[])new Object[0]), I18n.n_((String)"vradi.adminStatus.newStatusName", (Object[])new Object[0]), Status.class, AdminStatusUI.class),
    XML_STREAM(I18n.n_((String)"vradi.stream.category", (Object[])new Object[0]), I18n.n_((String)"vradi.adminXmlStream.newStreamName", (Object[])new Object[0]), XmlStream.class, AdminXmlStreamUI.class),
    WEB_HARVEST_STREAM(I18n.n_((String)"vradi.stream.category", (Object[])new Object[0]), I18n.n_((String)"vradi.adminXmlStream.newWebHarvestStreamName", (Object[])new Object[0]), WebHarvestStream.class, AdminXmlStreamUI.class),
    FORM_TYPE(I18n.n_((String)"vradi.formType.category", (Object[])new Object[0]), I18n.n_((String)"vradi.adminXmlStream.newFormTypeName", (Object[])new Object[0]), WikittyExtension.class, AdminFormTypeUI.class);

    private String categoryName;
    private String newEntityName;
    private Class<?> beanClass;
    private Class<?> uiClass;

    private AdminBeanConstant(String categoryName, String newEntityName, Class<?> beanClass, Class<?> uiClass) {
        this.categoryName = categoryName;
        this.newEntityName = newEntityName;
        this.beanClass = beanClass;
        this.uiClass = uiClass;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getNewEntityName() {
        return I18n._((String)this.newEntityName, (Object[])new Object[0]);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Class<?> getUIClass() {
        return this.uiClass;
    }

    public static AdminBeanConstant getConstantByUIClass(Class uiClass) {
        for (AdminBeanConstant constant : AdminBeanConstant.values()) {
            if (!uiClass.equals(constant.getUIClass())) continue;
            return constant;
        }
        return null;
    }

    public static AdminBeanConstant getConstantByBeanClass(Class beanClass) {
        for (AdminBeanConstant constant : AdminBeanConstant.values()) {
            if (!beanClass.equals(constant.getBeanClass())) continue;
            return constant;
        }
        return null;
    }

    public Object getBean(WikittyProxy proxy, String id) {
        WikittyExtension result = null;
        switch (this) {
            case CLIENT: {
                if (id == null) {
                    ClientImpl newClient = new ClientImpl();
                    newClient.setName(this.getNewEntityName());
                    result = newClient;
                    break;
                }
                result = proxy.restore(Client.class, id);
                break;
            }
            case GROUP: {
                if (id == null) {
                    GroupImpl newGroup = new GroupImpl();
                    newGroup.setName(this.getNewEntityName());
                    result = newGroup;
                    break;
                }
                result = proxy.restore(Group.class, id);
                break;
            }
            case USER: {
                if (id == null) {
                    UserImpl newUser = new UserImpl();
                    newUser.setCreationDate(new Date());
                    newUser.setBeginSearchDate(new Date());
                    newUser.setName(this.getNewEntityName());
                    newUser.setEnable(true);
                    newUser.setValidEmail(false);
                    result = newUser;
                    break;
                }
                result = proxy.restore(User.class, id);
                break;
            }
            case FORM_TYPE: {
                result = proxy.restoreExtensionLastVersion(id);
                break;
            }
            case XML_STREAM: {
                if (id == null) {
                    XmlStreamImpl newXmlStream = new XmlStreamImpl();
                    newXmlStream.setName(this.getNewEntityName());
                    result = newXmlStream;
                    break;
                }
                result = proxy.restore(XmlStream.class, id);
                break;
            }
            case WEB_HARVEST_STREAM: {
                if (id == null) {
                    WebHarvestStreamImpl newWebHarvest = new WebHarvestStreamImpl();
                    newWebHarvest.setName(I18n._((String)this.getNewEntityName(), (Object[])new Object[0]));
                    result = newWebHarvest;
                    break;
                }
                result = proxy.restore(WebHarvestStream.class, id);
            }
        }
        return result;
    }

    public static Class<?> getUIClass(String categoryName) {
        for (AdminBeanConstant constant : AdminBeanConstant.values()) {
            if (!categoryName.matches(".*" + constant.getCategoryName())) continue;
            return constant.getUIClass();
        }
        return null;
    }

    public static Class<?> getUIClass(Class<?> beanClass) {
        for (AdminBeanConstant constant : AdminBeanConstant.values()) {
            if (!beanClass.equals(constant.getBeanClass())) continue;
            return constant.getUIClass();
        }
        return null;
    }

    public static boolean isCategoryNode(VradiTreeNode node) {
        return AdminBeanConstant.isCategoryId(node.getId());
    }

    public static boolean isCategoryId(String id) {
        for (AdminBeanConstant constant : AdminBeanConstant.values()) {
            if (!id.contains(constant.categoryName)) continue;
            return true;
        }
        return false;
    }
}

