/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Client;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.nuiton.widget.tree.TreeFilter;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.WikittyExtension;

public class AdminNavTreeFilter
implements TreeFilter {
    private static final Log log = LogFactory.getLog(AdminNavTreeFilter.class);
    protected String filterString;

    public AdminNavTreeFilter(String filterString) {
        this.filterString = filterString.toLowerCase();
    }

    public boolean include(TreeModel model, Object node) {
        XmlStream xmlStream;
        WikittyProxy wikittyProxy;
        WikittyExtension formType;
        if (StringUtils.isEmpty((String)this.filterString)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Todo filter string : " + this.filterString + " on " + node));
        }
        VradiTreeNode vradiNode = (VradiTreeNode)((Object)node);
        String id = vradiNode.getId();
        Class nodeType = vradiNode.getInternalClass();
        if (vradiNode.isStringNode()) {
            return true;
        }
        if (nodeType.equals(Client.class)) {
            Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, id);
            if (client.getName().toLowerCase().contains(this.filterString)) {
                return true;
            }
            List users = VradiService.getVradiDataService().findClientUsers(id);
            if (users != null) {
                for (User user : users) {
                    if (!user.getName().toLowerCase().contains(this.filterString)) continue;
                    return true;
                }
            }
        } else if (nodeType.equals(User.class)) {
            User user = (User)VradiService.getWikittyProxy().restore(User.class, id);
            if (user.getName().toLowerCase().contains(this.filterString)) {
                return true;
            }
            VradiTreeNode clientNode = AdminNavigationTreeHelper.getParentNode(vradiNode, Client.class);
            if (clientNode != null) {
                Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, clientNode.getId());
                if (client.getName().toLowerCase().contains(this.filterString)) {
                    return true;
                }
            } else {
                VradiTreeNode groupNode = AdminNavigationTreeHelper.getParentNode(vradiNode, Group.class);
                Group group = (Group)VradiService.getWikittyProxy().restore(Group.class, groupNode.getId());
                if (group.getName().toLowerCase().contains(this.filterString)) {
                    return true;
                }
            }
        } else if (nodeType.equals(Group.class)) {
            Group group = (Group)VradiService.getWikittyProxy().restore(Group.class, id);
            if (group.getName().toLowerCase().contains(this.filterString)) {
                return true;
            }
            Set userIds = group.getUser();
            if (userIds != null) {
                List users = VradiService.getWikittyProxy().restore(User.class, new ArrayList(userIds));
                for (User user : users) {
                    if (!user.getName().toLowerCase().contains(this.filterString)) continue;
                    return true;
                }
            }
        } else if (nodeType.equals(WikittyExtension.class) ? (formType = (wikittyProxy = VradiService.getWikittyProxy()).restoreExtension(id)).getName().toLowerCase().contains(this.filterString) : nodeType.equals(XmlStream.class) && (xmlStream = (XmlStream)VradiService.getWikittyProxy().restore(XmlStream.class, id)).getName().toLowerCase().contains(this.filterString)) {
            return true;
        }
        return false;
    }
}

