/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SortedIntDocSet;

class DocSetCollector
extends Collector {
    int pos = 0;
    OpenBitSet bits;
    final int maxDoc;
    final int smallSetSize;
    int base;
    final int[] scratch;

    DocSetCollector(int smallSetSize, int maxDoc) {
        this.smallSetSize = smallSetSize;
        this.maxDoc = maxDoc;
        this.scratch = new int[smallSetSize];
    }

    public void collect(int doc) throws IOException {
        doc += this.base;
        if (this.pos < this.scratch.length) {
            this.scratch[this.pos] = doc;
        } else {
            if (this.bits == null) {
                this.bits = new OpenBitSet((long)this.maxDoc);
            }
            this.bits.fastSet(doc);
        }
        ++this.pos;
    }

    public DocSet getDocSet() {
        if (this.pos <= this.scratch.length) {
            return new SortedIntDocSet(this.scratch, this.pos);
        }
        for (int i = 0; i < this.scratch.length; ++i) {
            this.bits.fastSet(this.scratch[i]);
        }
        return new BitDocSet(this.bits, this.pos);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.base = docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }
}

