/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.offer.editors;

import java.io.UnsupportedEncodingException;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.ui.offer.editors.VradiEditorModel;

public class TextEditorModel
extends VradiEditorModel<String> {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(TextEditorModel.class);

    public void removeEndLine() {
        String text = (String)this.getValue();
        if (text == null) {
            return;
        }
        this.setValue(text.replace('\n', ' '));
    }

    public void convertToIso() {
        String text = (String)this.getValue();
        if (text == null) {
            return;
        }
        text = this.convertTo(text, "ISO-8859-1");
        this.setValue(text);
    }

    public void convertToUtf() {
        String text = (String)this.getValue();
        if (text == null) {
            return;
        }
        try {
            text = new String(text.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException eee) {
            log.error((Object)("Cant convert '" + text + "' to UTF8"), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        this.setValue(text);
    }

    public void removeXML() {
        String text = (String)this.getValue();
        if (text == null) {
            return;
        }
        text = text.replaceAll("<[^>]+>", "");
        this.setValue(text);
    }

    public void unescapeXML() {
        String text = (String)this.getValue();
        if (text == null) {
            return;
        }
        text = StringEscapeUtils.unescapeHtml((String)text);
        this.setValue(text);
    }

    protected String convertTo(String text, String encoding) {
        try {
            text = new String(text.getBytes(), encoding);
        }
        catch (UnsupportedEncodingException eee) {
            log.error((Object)("Cant convert '" + text + "' to " + encoding), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        return text;
    }
}

