/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.models;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiExtensionsListener;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.nuiton.wikitty.entities.WikittyExtension;

public class FormTypeModel
extends DefaultComboBoxModel
implements VradiExtensionsListener {
    private static final Log log = LogFactory.getLog(FormTypeModel.class);
    protected boolean firstNull = false;

    public FormTypeModel(boolean firstNull) {
        this.firstNull = firstNull;
        this.init();
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    public void init() {
        List<WikittyExtension> formTypes = null;
        try {
            formTypes = VradiService.getVradiDataService().getAllFormTypes();
        }
        catch (VradiException eee) {
            log.error((Object)"Cant get all forms types", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        this.removeAllElements();
        Collections.sort(formTypes, VradiComparators.EXTENSION_COMPARATOR);
        for (WikittyExtension formType : formTypes) {
            this.addElement(formType);
        }
        if (this.firstNull) {
            this.setSelectedItem(null);
        }
    }

    @Override
    public int getSize() {
        if (this.firstNull) {
            return super.getSize() + 1;
        }
        return super.getSize();
    }

    @Override
    public Object getElementAt(int index) {
        if (this.firstNull) {
            if (index == 0) {
                return null;
            }
            return super.getElementAt(index - 1);
        }
        return super.getElementAt(index);
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        this.init();
    }

    @Override
    public void extensionsRemoved(Set<String> removedNames) {
        this.init();
    }
}

